% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{down_shift}
\alias{down_shift}
\title{Remove introns and shift exons leftward}
\usage{
down_shift(transcript)
}
\arguments{
\item{transcript}{The GRanges object to remove introns from.}
}
\value{
A GRanges object with introns removed.
}
\description{
This function takes a GRanges object and moves each IRanges object within
next to each other starting at 1. This effectively removes the introns from
the GRanges object.
}
\examples{
# Create a simple GRanges object:
gr <- IRanges::IRanges(
  start = c(13, 40, 100),
  end = c(20, 53, 110))
# Downshift it and see the introns are removed:
down_shift(gr)

}
