% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_fusion_by.R
\name{get_fusion_by_gene_name}
\alias{get_fusion_by_gene_name}
\title{Find fusions that includes the given gene.}
\usage{
get_fusion_by_gene_name(fusion_list, gene_name)
}
\arguments{
\item{fusion_list}{A list of Fusion objects.}

\item{gene_name}{The gene name we're looking for.}
}
\value{
A list of Fusion objects.
}
\description{
Helper function to retrieve the Fusion objects that has geneName as one of
the partner genes.
}
\details{
Note: get_fusion_by_gene_name(fusionList, "MT") will match both MT-ND5 and
MT-ND4.
}
\examples{
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 1)
length(get_fusion_by_gene_name(fusions, "RCC1"))
# [1] 1

}
