% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read_ldef}
\alias{read_ldef}
\title{Function to read custom locus definition from file}
\usage{
read_ldef(file_path, genome = NA)
}
\arguments{
\item{file_path}{A file path for the custom locus definition.}

\item{genome}{A genome from \code{supported_genomes()}, default \code{NA}.}
}
\value{
A \code{LocusDefinition} class object with slots \code{dframe},
\code{granges}, \code{genome.build}, and \code{organism}.
}
\description{
This function reads a tab-delimited text (with a header) file that should have
columns 'chr', 'start', 'end', and a column named 'gene_id' (or 'geneid') with the
Entrez Gene ID. If a \code{supported_genomes()} is given, then a column
of gene symbols named 'symbol', will be added. If an unsupported genome is
used there are two options: 1) Have a column named 'symbols' with the gene
symbols in the custom locus definition, and leave \code{genome = NA}, or 2)
leave \code{genome = NA}, do not provide gene symbols, and NAs will be used.
}
