% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkProjectFolder.R
\name{checkProjectFolder}
\alias{checkProjectFolder}
\title{Check project folder}
\usage{
checkProjectFolder(
  pathToExperiment = NULL,
  pathToGTF = NULL,
  pathToMotifs = NULL,
  pathToMiRs = NULL,
  pathToTranscripts = NULL,
  pathToTraits = NULL
)
}
\arguments{
\item{pathToExperiment}{A string containing the path to the experiment.txt
file. The file experiment.txt contains the experiment design information.
It must have at least 3 columns with headers:
- label (1st column): unique names of the samples (short but informative).
- fileName (2nd column): name of the input files - e.g. circRNAs_X.txt, where
x can be can be 001, 002 etc.
- group (3rd column): biological conditions - e.g. A or B; healthy or
diseased if you have only 2 conditions.
By default pathToExperiment is set to NULL and the file it is searched in the
working directory. If experiment.txt is located in a different directory
then the path needs to be specified.}

\item{pathToGTF}{A string containing the path to the the GTF file.
Use the same annotation file used during the RNA-seq mapping procedure.
By default pathToGTF is set to NULL and the file it is searched in the
working directory. If .gtf is located in a different directory then the
path needs to be specified.}

\item{pathToMotifs}{A string containing the path to the motifs.txt
file. The file motifs.txt contains motifs/regular expressions specified
by the user. It must have 3 columns with headers:
- id (1st column): name of the motif. - e.g. RBM20 or motif1.
- motif (2nd column): motif/pattern to search.
- length (3rd column): length of the motif.
By default pathToMotifs is set to NULL and the file it is searched in the
working directory. If motifs.txt is located in a different directory then
the path needs to be specified. If this file is absent or empty only the
motifs of RNA Binding Proteins in the ATtRACT or MEME database are considered
in the motifs analysis.}

\item{pathToMiRs}{A string containing the path to the miRs.txt file.
The file miRs.txt contains the microRNA ids from miRBase
specified by the user. It must have one column with header id. The first row
must contain the miR name starting with the ">", e.g >hsa-miR-1-3p. The
sequences of the miRs will be automatically retrieved from the mirBase latest
release or from the given mature.fa file, that should be present in the
working directory. By default pathToMiRs is set to NULL and the file it is
searched in the working directory. If miRs.txt is located in a different
directory then the path needs to be specified. If this file is absent or
empty, all miRs of the species specified in input are considered in the
miRNA analysis.}

\item{pathToTranscripts}{A string containing the path to the transcripts.txt
file. The file transcripts.txt contains the transcript ids of the
circRNA host gene to analyze. It must have one column with header id.
By default pathToTranscripts is set to NULL and the file it is searched in
the working directory. If transcripts.txt is located in a different
directory then the path needs to be specified. If this file is empty or
absent the longest transcript of the circRNA host gene containing the
back-spliced junctions are considered in the annotation analysis.}

\item{pathToTraits}{A string containing the path to the traits.txt
file. contains diseases/traits specified by the user. It must
have one column with header id. By default pathToTraits is set to NULL and
the file it is searched in the working directory. If traits.txt is located
in a different directory then the path needs to be specified. If this file is
absent or empty SNPs associated with all diseases/traits in
the GWAS catalog are considered in the SNPs analysis.}
}
\value{
An integer. If equals to 0 the project folder is correctly
set up.
}
\description{
The function checkProjectFolder() verifies that the
project folder is set up correctly. It checks that the mandatory files
(.gtf file, the folders with the circRNAs_X.txt files and experiemnt.txt)
are present in the working directory.The function
\code{\link{initCircRNAprofiler}} can be used to initialize the project folder.
}
\examples{
checkProjectFolder()

}
