% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFilesPredictionTool.R
\name{importKnife}
\alias{importKnife}
\title{Import circRNAs detected by KINFE}
\usage{
importKnife(pathToFile)
}
\arguments{
\item{pathToFile}{A character string specifying the path to the file
containing the detected circRNAs.}
}
\value{
A data frame.
}
\description{
The function importKnife is specifically designed to read and
adapt the KNIFE v1.5 output file (circJuncProbs.txt).
See \url{https://github.com/lindaszabo/KNIFE.git} for more details.
}
\examples{
# Path to an example file containing circRNAs detected by KNIFE
pathToFile <- system.file("extdata", "knife/circRNAs_001.txt",
    package="circRNAprofiler")

# Inner function.
# Import circRNAs.
importKnife(pathToFile)

}
\keyword{internal}
