% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importFilesPredictionTool.R
\name{importMapSplice}
\alias{importMapSplice}
\title{Import circRNAs detected by MapSplice2}
\usage{
importMapSplice(pathToFile)
}
\arguments{
\item{pathToFile}{A character string specifying the path to the file
containing the detected circRNAs.}
}
\value{
A data frame.
}
\description{
The function importMapSplice is specifically designed to read
and adapt the MapSplice2-v2.2.0 output file (circularRNAs.txt).
See \url{https://github.com/davidroberson/MapSplice2} for more details.
}
\examples{
# Path to an example file containing circRNA detected by MapSplice2
pathToFile <- system.file("extdata", "mapsplice/circRNAs_001.txt",
    package="circRNAprofiler")

# Inner function.
# Import circRNAs.
importMapSplice(pathToFile)

}
\keyword{internal}
