% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlots.R
\name{plotExPosition}
\alias{plotExPosition}
\title{Plot back-spliced exon positions}
\usage{
plotExPosition(annotatedBSJs, title = "", n = 0, flip = FALSE)
}
\arguments{
\item{annotatedBSJs}{A data frame with the annotated back-spliced junctions.
This data frame can be generated with \code{\link{annotateBSJs}}.}

\item{title}{A character string specifying the title of the plot.}

\item{n}{An integer specyfing the position counts cut-off. If 0 is specified
all position are plotted. Deafult value is 0.}

\item{flip}{A logical specifying whether to flip the transcripts. If TRUE all
transcripts are flipped and the last exons will correspond to the first ones,
the second last exons to the second ones etc. Default value is FALSE.}
}
\value{
A ggplot object.
}
\description{
The function plotExPosition() generates a bar chart showing
the position of the back-spliced exons within the transcript.
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first 10 back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1:10, ], gtf)

# Plot
p <- plotExPosition(annotatedBSJs, title = "", n = 0, flip = FALSE)
p


}
