% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlots.R
\name{plotLenBSEs}
\alias{plotLenBSEs}
\title{Plot length back-spliced exons}
\usage{
plotLenBSEs(
  annotatedFBSJs,
  annotatedBBSJs,
  df1Name = "foreground",
  df2Name = "background",
  title = "",
  setyLim = FALSE,
  ylim = c(0, 8)
)
}
\arguments{
\item{annotatedFBSJs}{A data frame with the annotated back-spliced junctions
(e.g. detected). It can be generated with \code{\link{annotateBSJs}}.
These act as foreground back-spliced junctions.}

\item{annotatedBBSJs}{A data frame with the annotated back-spliced junctions
(e.g. randomly selected). It can generated with \code{\link{annotateBSJs}}.
These act as background back-spliced junctions.}

\item{df1Name}{A string specifying the name of the first data frame. This
will be displayed in the legend of the plot.}

\item{df2Name}{A string specifying the name of the first data frame. This
will be displayed in the legend of the plot.}

\item{title}{A character string specifying the title of the plot}

\item{setyLim}{A logical specifying whether to set y scale limits.
If TRUE the value in ylim will be used. Deafult value is FALSE.}

\item{ylim}{An integer specifying the lower and upper y axis limits
Deafult values are c(0, 8).}
}
\value{
A ggplot object.
}
\description{
The function plotLenBSEs() generates vertical boxplots for
comparison of length of back-spliced exons (e.g. detected Vs randomly
selected).
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first 10 back-spliced junctions
annotatedFBSJs <- annotateBSJs(mergedBSJunctions[1:10, ], gtf)

# Get random back-spliced junctions
randomBSJunctions <- getRandomBSJunctions(n = 10, f = 10, gtf)

# Annotate random back-spliced junctions
annotatedBBSJs <- annotateBSJs(randomBSJunctions, gtf, isRandom = TRUE)

# Plot
p <- plotLenBSEs(
    annotatedFBSJs,
    annotatedBBSJs,
    df1Name = "foreground",
    df2Name = "background",
    title = "")
p


}
