% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPlots.R
\name{plotMiR}
\alias{plotMiR}
\title{Plot miRNA analysis results}
\usage{
plotMiR(rearragedMiRres, n = 40, color = "blue", miRid = FALSE, id = 1)
}
\arguments{
\item{rearragedMiRres}{A list containing containing rearranged
miRNA analysis results. See \code{\link{getMiRsites}} and then
\code{\link{rearrangeMiRres}}.}

\item{n}{An integer specifying the miRNA binding sites cut-off. The miRNA
with a number of binding sites equals or higher to the cut-off will be
colored. Deafaut value is 40.}

\item{color}{A string specifying the color of the top n miRs. Default value
is "blue".}

\item{miRid}{A logical specifying whether or not to show the miR ids in
the plot. default value is FALSE.}

\item{id}{An integer specifying which element of the list
rearragedMiRres to plot. Each element of the list contains
the miR resutls relative to one circRNA. Deafult value is 1.}
}
\value{
A ggplot object.
}
\description{
The function plotMiR() generates a scatter plot showing the
number of miRNA binding sites for each miR found in the target sequence.
}
\examples{
# Load data frame containing detected back-spliced junctions
data("mergedBSJunctions")

# Load short version of the gencode v19 annotation file
data("gtf")

# Annotate the first back-spliced junctions
annotatedBSJs <- annotateBSJs(mergedBSJunctions[1, ], gtf)

# Get genome
genome <- BSgenome::getBSgenome("BSgenome.Hsapiens.UCSC.hg19")

# Retrieve target sequences.
targets <- getCircSeqs(
    annotatedBSJs,
    gtf,
    genome)

# Screen target sequence for miR binding sites.
pathToMiRs <- system.file("extdata", "miRs.txt", package="circRNAprofiler")

# miRsites <- getMiRsites(
#     targets,
#     miRspeciesCode = "hsa",
#     miRBaseLatestRelease = TRUE,
#     totalMatches = 6,
#     maxNonCanonicalMatches = 1,
#     pathToMiRs)

# Rearrange miR results
# rearragedMiRres <- rearrangeMiRres(miRsites)

# Plot
# p <- plotMiR(
#     rearragedMiRres,
#     n = 20,
#     color = "blue",
#     miRid = TRUE,
#     id = 3)
# p

}
