% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getClusterIndex.R
\name{getClusterIndex}
\alias{getClusterIndex}
\alias{getClusterIndex,ClusterExperiment-method}
\alias{getSingleClusterIndex,ClusterExperiment-method}
\alias{getSingleClusterIndex}
\title{getClusterIndex}
\usage{
\S4method{getClusterIndex}{ClusterExperiment}(
  object,
  whichClusters,
  noMatch = c("silentlyRemove", "throwError")
)

\S4method{getSingleClusterIndex}{ClusterExperiment}(object, whichCluster, passedArgs = NULL, ...)
}
\arguments{
\item{object}{a ClusterExperiment object}

\item{whichClusters}{argument that can be either numeric or character vector
indicating the clusterings to be used. See details of \code{\link{getClusterIndex}}.}

\item{noMatch}{how to handle if there is no match to an given value of \code{whichClusters}.
"silentlyRemove" means that no error will be given, and the result will be just those that
do match (resulting in a vector of length zero if there are none that match). "throwError"
means that the function will stop with an error describing the problem with the match.}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{passedArgs}{other arguments passed to the function (only used internally)}

\item{...}{Not for user use. Argument allows function \code{getSingleClusterIndex}
to catch the wrong argument (the plural \code{whichClusters} argument rather than 
singular \code{whichCluster}).}
}
\value{
\code{getClusterIndex} returns a vector of all numeric indices that are indicated by the requested \code{whichClusters}. Note that there is not a one-to-one match between input values and returned values since there may be more than one value for a given value of \code{whichClusters} or no value at all.
}
\description{
Finds index of clustering in clusterMatrix slot of object based on descriptions of clusters.
}
\details{
The function \code{getClusterIndex} is largely used internally to parse the argument \code{whichClusters} which is used as an argument extensively across functions in this package. Note that some functions require the match return a single clustering, in which case those functions use the function \code{getSingleClusterIndex} with the singular argument \code{whichCluster} and returns an error if it indicates more than one clustering. Furthermore \code{getSingleClusterIndex} does not allow for any mismatches (\code{noMatch="throwError"}. Otherwise the parsing of the two arguments \code{whichClusters} and \code{whichCluster} is the same, and is described in what follows.

If \code{whichClusters} is numeric, then the function just returns the 
 numeric values of \code{whichClusters}, after checking that they are valid. If any are invalid, they are silently removed if \code{silentlyRemove=TRUE}. The values will be returned  \emph{in the order given}, so this argument can also be used to defined by functions to give an
  ordering for the clusterings (as relevant).

If \code{whichClusters} is a character value, then it the function attempts to use the character value to identify the clustering. The value of the argument is first matched against a set of "special" values: "workflow","all","none","primaryCluster","dendro" using the argument \code{\link{match.arg}}, which does partial matching. If whichClusters is a vector of values, only the first value of the vector is matched against these values and if it matches, the remaining values are ignored.  If it matches one of these values, then the cluster indices are given as follows.
\itemize{
 \item{"workflow"}{all clusterings in the current workflow (see \code{\link{workflowClusters}})}
 \item{"all"}{all clusterings, with the primary clustering put first.}
 \item{"none"}{no clusterings}
 \item{"primaryCluster"}{the primary clustering index as given by \code{\link{primaryClusterIndex}}}
 \item{"dendro"}{the index of the clustering given to create the cluster dendrogram, if it exists}
}
 @details If \code{whichClusters} is a character value, but its first element does not match these predesignated values, then all the values of \code{whichClusters} are attempted to be matched to the \code{\link{clusterTypes}} of the object. Note that there may be more than one clustering that matches a given type. For any entries that do not match a value in  \code{clusterTypes(object)} are then matched based on the value of \code{\link{clusterLabels}} of the object.
}
\examples{
#load CE object
data(rsecFluidigm)
# get the cluster index from mergeClusters step
getClusterIndex(rsecFluidigm,whichClusters="mergeClusters")
# get the cluster indices from mergeClusters step
getClusterIndex(rsecFluidigm,whichClusters="clusterMany")
}
