% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHeatmap.R
\docType{methods}
\name{plotHeatmap}
\alias{plotHeatmap}
\alias{plotHeatmap,SingleCellExperiment-method}
\alias{plotHeatmap,SummarizedExperiment-method}
\alias{plotHeatmap,table-method}
\alias{plotHeatmap,ClusterExperiment-method}
\alias{plotHeatmap,data.frame-method}
\alias{plotHeatmap,ExpressionSet-method}
\alias{plotHeatmap,matrixOrHDF5-method}
\alias{plotCoClustering,ClusterExperiment-method}
\alias{plotCoClustering}
\title{Heatmap for showing clustering results and more}
\usage{
\S4method{plotHeatmap}{SingleCellExperiment}(data, isCount = FALSE, transFun = NULL, ...)

\S4method{plotHeatmap}{SummarizedExperiment}(data, isCount = FALSE, transFun = NULL, ...)

\S4method{plotHeatmap}{table}(data, ...)

\S4method{plotHeatmap}{ClusterExperiment}(
  data,
  clusterSamplesData = c("dendrogramValue", "hclust", "orderSamplesValue",
    "primaryCluster"),
  clusterFeaturesData = "var",
  nFeatures = NA,
  visualizeData = c("transformed", "centeredAndScaled", "original"),
  whichClusters = c("primary", "workflow", "all", "none"),
  colData = NULL,
  clusterFeatures = TRUE,
  nBlankLines = 2,
  colorScale,
  whichAssay = 1,
  ...
)

\S4method{plotHeatmap}{data.frame}(data, ...)

\S4method{plotHeatmap}{ExpressionSet}(data, ...)

\S4method{plotHeatmap}{matrixOrHDF5}(
  data,
  colData = NULL,
  clusterSamplesData = NULL,
  clusterFeaturesData = NULL,
  whColDataCont = NULL,
  clusterSamples = TRUE,
  showSampleNames = FALSE,
  clusterFeatures = TRUE,
  showFeatureNames = FALSE,
  colorScale = seqPal5,
  clusterLegend = NULL,
  alignColData = FALSE,
  unassignedColor = "white",
  missingColor = "grey",
  breaks = NA,
  symmetricBreaks = FALSE,
  capBreaksLegend = FALSE,
  isSymmetric = FALSE,
  overRideClusterLimit = FALSE,
  plot = TRUE,
  labelTracks = TRUE,
  ...
)

\S4method{plotCoClustering}{ClusterExperiment}(data, invert, saveDistance = FALSE, ...)
}
\arguments{
\item{data}{data to use to determine the heatmap. Can be a matrix,
\code{\link{ClusterExperiment}},
\code{\link[SingleCellExperiment]{SingleCellExperiment}} or
\code{\link[SummarizedExperiment]{SummarizedExperiment}} object. The
interpretation of parameters depends on the type of the input to
\code{data}.}

\item{isCount}{if \code{transFun=NULL}, then \code{isCount=TRUE} will
determine the transformation as defined by \code{function(x){log2(x+1)}},
and \code{isCount=FALSE} will give a transformation function
\code{function(x){x}}. Ignored if \code{transFun=NULL}. If object is of
class \code{ClusterExperiment}, the stored transformation will be used and
giving this parameter will result in an error.}

\item{transFun}{a transformation function to be applied to the data. If the
transformation applied to the data creates an error or NA values, then the
function will throw an error. If object is of class
\code{ClusterExperiment}, the stored transformation will be used and giving
this parameter will result in an error.}

\item{...}{for signature \code{matrix}, arguments passed to \code{aheatmap}.
For the other signatures, passed to the method for signature \code{matrix}.
Not all arguments can be passed to \code{aheatmap} effectively, see
details.}

\item{clusterSamplesData}{If \code{data} is a matrix,
 \code{clusterSamplesData} is either a matrix that will be used by
 \code{hclust} to define the hiearchical clustering of samples (e.g.
 normalized data) or a pre-existing dendrogram (of class
\code{\link[stats]{dendrogram}}) that clusters the samples. If
 \code{data} is a \code{ClusterExperiment} object, \code{clusterSamplesData}
 should be either character or integers or logical which indicates how (and
 whether) the samples should be clustered (or gives indices of the order for
 the samples). See details.}

\item{clusterFeaturesData}{If \code{data} is a matrix, either a matrix that
will be used in \code{hclust} to define the hiearchical clustering of
features (e.g. normalized data) or a pre-existing dendrogram that clusters
the features. If \code{data} is a \code{ClusterExperiment} object, the
input should be either character or integers indicating which features
should be used (see details).}

\item{nFeatures}{integer indicating how many features should be used (if
\code{clusterFeaturesData} is 'var' or 'PCA').}

\item{visualizeData}{either a character string, indicating what form of the
data should be used for visualizing the data (i.e. for making the
color-scale), or a data.frame/matrix with same number of samples as
\code{assay(data)}. If a new data.frame/matrix, any character arguments to
clusterFeaturesData will be ignored.}

\item{whichClusters}{argument that can be either numeric or character vector
indicating the clusterings to be used. See details of \code{\link{getClusterIndex}}.}

\item{colData}{If input to \code{data} is either a
\code{\link{ClusterExperiment}},or \code{SummarizedExperiment} object or
\code{SingleCellExperiment}, then \code{colData} must index the
colData stored as a \code{DataFrame} in \code{colData} slot of the
object. Whether that data is continuous or not will be determined by the
properties of \code{colData} (no user input is needed). If input to
\code{data} is matrix, \code{colData} is a matrix of additional data on
the samples to show above heatmap. In this case, unless indicated by
\code{whColDataCont}, \code{colData} will be converted into factors,
even if numeric. ``-1'' indicates the sample was not assigned to a cluster
and gets color `unassignedColor' and ``-2`` gets the color 'missingColor'.}

\item{clusterFeatures}{Logical as to whether to do hiearchical clustering of
features (if FALSE, any input to clusterFeaturesData is ignored).}

\item{nBlankLines}{Only applicable if input is \code{ClusterExperiment} object. Indicates the number of lines to put between groups of features if \code{clusterFeaturesData} gives groups of genes (see details and \code{\link{makeBlankData}}).}

\item{colorScale}{palette of colors for the color scale of the heatmap.}

\item{whichAssay}{numeric or character specifying which assay to use. See
\code{\link[SummarizedExperiment]{assay}} for details.}

\item{whColDataCont}{Which of the \code{colData} columns are continuous
and should not be converted to counts. \code{NULL} indicates no additional
\code{colData}. Only used if \code{data} input is matrix.}

\item{clusterSamples}{Logical as to whether to do hierarchical clustering of
cells (if FALSE, any input to clusterSamplesData is ignored).}

\item{showSampleNames}{Logical as to whether show sample names.}

\item{showFeatureNames}{Logical as to whether show feature names.}

\item{clusterLegend}{Assignment of colors to the clusters. If \code{NULL},
\code{colData} columns will be assigned colors internally. See details
for more.}

\item{alignColData}{Logical as to whether should align the colors of the
\code{colData} (only if \code{clusterLegend} not given and
\code{colData} is not \code{NULL}).}

\item{unassignedColor}{color assigned to cluster values of '-1'
("unassigned").}

\item{missingColor}{color assigned to cluster values of '-2' ("missing").}

\item{breaks}{Either a vector of breaks (should be equal to length 52), or a
number between 0 and 1, indicating that the breaks should be equally spaced
(based on the range in the data) upto the `breaks' quantile, see
\code{\link{setBreaks}}}

\item{symmetricBreaks}{logical as to whether the breaks created for the color
scale should be symmetrical around 0}

\item{capBreaksLegend}{logical as to whether the legend for the breaks should
be capped. Only relevant if \code{breaks} is a value < 1, in which case if
\code{capBreaksLegend=TRUE}, only the values between the quantiles
requested will show in the color scale legend.}

\item{isSymmetric}{logical. if TRUE indicates that the input matrix is
symmetric. Useful when plotting a co-clustering matrix or other sample by
sample matrices (e.g., correlation).}

\item{overRideClusterLimit}{logical. Whether to override the internal limit
that only allows 10 clusterings/annotations. If overridden, may result in
incomprehensible errors from \code{aheatmap}. Only override this if you
have a very large plotting device and want to see if \code{aheatmap} can
render it.}

\item{plot}{logical indicating whether to plot the heatmap. Mainly useful for
package mantaince to avoid calls to aheatmap on unit tests that take a long
time.}

\item{labelTracks}{logical, whether to put labels next to the color tracks 
corresponding to the colData.}

\item{invert}{logical determining whether the coClustering matrix should be
inverted to be 1-coClustering for plotting. By default, if the diagonal
elements are all zero, invert=TRUE, and otherwise invert=FALSE. If
coClustering matrix is not a 0-1 matrix (e.g. if equal to a distance matrix
output from \code{\link{clusterSingle}}, then the user should manually set
this parameter to FALSE.)}

\item{saveDistance}{logical. When the \code{coClustering} slot contains
indices of the clusterings or a NxB set of clusterings, the hamming
distance will be calculated before running the plot. This argument
determines whether the \code{ClusterExperiment} object with that distance
in \code{coClustering} slot should be returned (so as to avoid
re-calculating it in the future) or not.}
}
\value{
Returns (invisibly) a list with elements
\itemize{
\item{\code{aheatmapOut}}{ The output from the final call of
\code{\link[NMF]{aheatmap}}.}
\item{\code{colData}}{ the annotation data.frame given to the argument
\code{annCol} in \code{aheatmap}.}
\item{\code{clusterLegend}}{ the annotation colors given to the argument
\code{annColors} \code{aheatmap}.}
\item{\code{breaks}}{ The breaks used for \code{aheatmap}, after adjusting
for quantile.}
}
}
\description{
Make heatmap with color scale from one matrix and hiearchical
  clustering of samples/features from another. Also built in functionality
  for showing the clusterings with the heatmap. Builds on
  \code{\link[NMF]{aheatmap}} function of \code{NMF} package.
}
\details{
The plotHeatmap function calls \code{\link[NMF]{aheatmap}} to draw
  the heatmap. The main points of \code{plotHeatmap} are to 1) allow for
  different matrix inputs, separating out the color scale visualization and
  the clustering of the samples/features. 2) to visualize the clusters and
  meta data with the heatmap. The intended use case is to allow the user to
  visualize the original count scale of the data (on the log-scale), but
  create the hierarchical clustering on another, more appropriate dataset for
  clustering, such as normalized data. Similarly, some of the palettes in the
  package were developed assuming that the visualization might be on
  unscaled/uncentered data, rather than the residual from the mean of the
  gene, and thus palettes need to take on a greater range of relevant values
  so as to show meaningful comparisons with genes on very different scales.

If \code{data} is a \code{ClusterExperiment} object,
  \code{visualizeData} indicates what kind of transformation should be done
  to \code{assay(data)} for calculating the color scale. The features will be
  clustered based on these data as well. A different data.frame or matrix can
  be given for the visualization. For example, if the
  \code{ClusterExperiment} object contains normalized data, but the user
  wishes that the color scale be based on the log-counts for easier
  interpretation, \code{visualizeData} could be set to be the
  \code{log2(counts + 1)}.

If \code{data} is a \code{ClusterExperiment} object,
  \code{clusterSamplesData} can be used to indicate the type of clustering
  for the samples. If equal to `dendrogramValue` the dendrogram stored in
  \code{data} will be used; if dendrogram is missing, a new one will be
  created based on the \code{primaryCluster} of data using
  \code{\link{makeDendrogram}}, assuming no errors are created (if errors are
  created, then \code{clusterSamplesData} will be set to "primaryCluster").
  If \code{clusterSamplesData} is equal to "hclust", then standard
  hierachical clustering of the transformed data will be used. If
  \code{clusterSamplesData} is equal to 'orderSamplesValue' no clustering of
  the samples will be done, and instead the samples will be ordered as in the
  slot \code{orderSamples} of \code{data}. If \code{clusterSamplesData} is
  equal to 'primaryCluster', again no clustering will be done, and instead
  the samples will be ordered based on grouping the samples to match the
  primaryCluster of \code{data}; however, if the primaryCluster of
  \code{data} is only one cluster or consists soley of -1/-2 values,
  \code{clusterSamplesData} will be set to "hclust". If
  \code{clusterSamplesData}  is not a character value,
  \code{clusterSamplesData} can be a integer valued vector giving the order
  of the samples.

If \code{data} is a matrix, then \code{colData} is a data.frame
  of annotation data to be plotted above the heatmap and
  \code{whColDataCont} gives the index of the column(s) of this dataset
  that should be consider continuous. Otherwise the annotation data for
  \code{colData} will be forced into a factor (which will be nonsensical
  for continous data). If \code{data} is a \code{ClusterExperiment} object,
  \code{colData} should refer to a index or column name of the
  \code{colData} slot of \code{data}. In this case \code{colData} will be
  added to any choices of clusterings chosen by the \code{whichClusters}
  argument (if any). If both clusterings and sample data are chosen, the
  clusterings will be shown closest to data (i.e. on bottom).

If \code{data} is a \code{ClusterExperiment} object,
  \code{clusterFeaturesData} is not a dataset, but instead indicates which
  features should be shown in the heatmap. In this case
  \code{clusterFeatures} can be one of the following: \itemize{ \item{"all"}{
  All rows/genes will be shown} \item{character giving dimensionality
  reduction}{Should match one of values saved in \code{reducedDims} slot or a
  builtin function in \code{listBuiltInReducedDims()}. \code{nFeatures} then
  gives the number of dimensions to show. The heatmap will then be of the
  dimension reduction vectors} \item{character giving filtering}{ Should
  match one of values saved in \code{filterStats} slot or a builtin function
  in \code{listBuiltInFilterStats()}. \code{nFeatures} gives the number of
  genes to keep after filtering.} \item{character giving gene/row names}{ }
  \item{vector of integers giving row indices}{ } \item{a list of indices or
  rownames}{This is used to indicate that the features should be grouped
  according to the elements of the list, with blank (white) space between
  them (see \code{\link{makeBlankData}} for more details). In this case, no
  clustering is done of the features.} }

If \code{breaks} is a numeric value between 0 and 1, then
  \code{breaks} is assumed to indicate the upper quantile (on the log scale)
  at which the heatmap color scale should stop. For example, if
  \code{breaks=0.9}, then the breaks will evenly spaced up until the 0.9
  upper quantile of \code{data}, and then all values after the 0.9 quantile
  will be absorbed by the upper-most color bin. This can help to reduce the
  visual impact of a few highly expressed genes (features).

Note that plotHeatmap calls \code{\link[NMF]{aheatmap}} under the
  hood. This allows you to plot multiple heatmaps via
  \code{par(mfrow=c(2,2))}, etc. However, the dendrograms do not resize if
  you change the size of your plot window in an interactive session of R
  (this might be a problem for RStudio if you want to pop it out into a large
  window...). Also, plotting to a pdf adds a blank page; see help pages of
  \code{\link[NMF]{aheatmap}} for how to turn this off.

\code{clusterLegend} takes the place of argument \code{annColors}
  from \code{aheatmap} for giving colors to the annotation on the heatmap.
  \code{clusterLegend} should be list of length equal to
  \code{ncol(colData)} with names equal to the colnames of
  \code{colData}. Each element of the list should be a either the format
  requested by \code{\link[NMF]{aheatmap}} (a vector of colors with names
  corresponding to the levels of the column of \code{colData}), or should
  be format of the \code{clusterLegend} slot in a \code{ClusterExperiment}
  object. Color assignments to the rows/genes should also be passed via
  \code{clusterLegend} (assuming \code{annRow} is an argument passed to
  \code{...}). If \code{clusterFeaturesData} is a \emph{named} list
  describing groupings of genes then the colors for those groups can be given
  in \code{clusterLegend} under the name "Gene Group".

If you have a factor with many levels, it is important to note that
  \code{\link[NMF]{aheatmap}} does not recycle colors across factors in the
  \code{colData}, and in fact runs out of colors and the remaining levels
  get the color white. Thus if you have many factors or many levels in those
  factors, you should set their colors via \code{clusterLegend}.

Many arguments can be passed on to \code{aheatmap}, however, some are set
  internally by \code{plotHeatmap.} In particular, setting the values of
  \code{Rowv} or \code{Colv} will cause errors. \code{color} in
  \code{aheatmap} is replaced by \code{colorScale} in \code{plotHeatmap.} The
  \code{annCol} to give annotation to the samples is replaced by the
  \code{colData}; moreover, the \code{annColors} option in \code{aheatmap}
  will also be set internally to give more vibrant colors than the default in
  \code{aheatmap} (for \code{ClusterExperiment} objects, these values can
  also be set in the \code{clusterLegend} slot ). Other options should be
  passed on to \code{aheatmap}, though they have not been all tested. Useful options
 include \code{treeheight=0} to suppress plotting of the dendrograms, 
 \code{annLegend=FALSE} to suppress the legend of factors shown beside columns/rows, 
 and \code{cexRow=0} or \code{cexCol=0} to suppress plotting of row/column labels.

\code{plotCoClustering} is a convenience function to plot the
  heatmap of the co-clustering distance matrix from the \code{coClustering}
  slot of a \code{ClusterExperiment} object (either by calculating the
  hamming distance of the clusterings stored in the \code{coClustering} slot,
  or the distance stored in the \code{coClustering} slot if it has already
  been calculated.
}
\examples{
\dontrun{
data(simData)

cl <- rep(1:3,each=100)
cl2 <- cl
changeAssign <- sample(1:length(cl), 80)
cl2[changeAssign] <- sample(cl[changeAssign])
ce <- ClusterExperiment(simCount, cl2, transformation=function(x){log2(x+1)})

#simple, minimal, example. Show counts, but cluster on underlying means
plotHeatmap(ce)

#assign cluster colors
colors <- bigPalette[20:23]
names(colors) <- 1:3
plotHeatmap(data=simCount, clusterSamplesData=simData,
colData=data.frame(cl), clusterLegend=list(colors))

#show two different clusters
anno <- data.frame(cluster1=cl, cluster2=cl2)
out <- plotHeatmap(simData, colData=anno)

#return the values to see format for giving colors to the annotations
out$clusterLegend

#assign colors to the clusters based on plotClusters algorithm
plotHeatmap(simData, colData=anno, alignColData=TRUE)

#assign colors manually
annoColors <- list(cluster1=c("black", "red", "green"),
cluster2=c("blue","purple","yellow"))

plotHeatmap(simData, colData=anno, clusterLegend=annoColors)

#give a continuous valued -- need to indicate columns
anno2 <- cbind(anno, Cont=c(rnorm(100, 0), rnorm(100, 2), rnorm(100, 3)))
plotHeatmap(simData, colData=anno2, whColDataCont=3)

#compare changing breaks quantile on visual effect
par(mfrow=c(2,2))
plotHeatmap(simData, colorScale=seqPal1, breaks=1, main="Full length")
plotHeatmap(simData,colorScale=seqPal1, breaks=.99, main="0.99 Quantile Upper
Limit")
plotHeatmap(simData,colorScale=seqPal1, breaks=.95, main="0.95 Quantile Upper
Limit")
plotHeatmap(simData, colorScale=seqPal1, breaks=.90, main="0.90 Quantile
Upper Limit")
}

}
\seealso{
\code{\link[NMF]{aheatmap}}, \code{\link{makeBlankData}}, \code{\link{showHeatmapPalettes}}, \code{\link{makeDendrogram}}, \code{\link[stats]{dendrogram}}
}
\author{
Elizabeth Purdom
}
