% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllHelper.R
\name{renameClusters}
\alias{renameClusters}
\alias{renameClusters,ClusterExperiment,character-method}
\alias{recolorClusters,ClusterExperiment,character-method}
\alias{recolorClusters}
\title{Change assigned names or colors of clusters}
\usage{
\S4method{renameClusters}{ClusterExperiment,character}(
  object,
  value,
  whichCluster = "primary",
  matchTo = c("name", "clusterIds")
)

\S4method{recolorClusters}{ClusterExperiment,character}(
  object,
  value,
  whichCluster = "primary",
  matchTo = c("name", "clusterIds")
)
}
\arguments{
\item{value}{The value to be substituted in the corresponding slot. See the
slot descriptions in \code{\link{ClusterExperiment}} for details on what
objects may be passed to these functions.}

\item{whichCluster}{argument that can be a single numeric or character value
indicating the \emph{single} clustering to be used. Giving values that result in more than one clustering will result in an error. See details of \code{\link{getClusterIndex}}.}

\item{matchTo}{whether to match to the cluster name
(\code{"name"}) or internal cluster id (\code{"clusterIds"})}
}
\value{
\code{renameClusters} changes the names assigned to clusters within a
  clustering

\code{recolorClusters} changes the colors assigned to clusters within
  a clustering
}
\description{
Change the assigned names or colors of the clusters in a
  clustering stored in the clusterLegend slot of the object.
}
\examples{
#create CE object
data(simData)
cl1 <- clusterSingle(simData, subsample=FALSE,
sequential=FALSE, mainClusterArgs=list(clusterArgs=list(k=3), 
clusterFunction="pam"))
#Give names to the clusters
clusterLegend(cl1)
cl1<-renameClusters(cl1, c("1"="A","2"="B","3"="C"), matchTo="clusterIds")
clusterLegend(cl1)
# Change name of single one
cl1<-renameClusters(cl1, c("1"="D"), matchTo="clusterIds")
clusterLegend(cl1)
# Match to existing name, rather than clusterId
cl1<-renameClusters(cl1, c("B"="N"), matchTo="name")
clusterLegend(cl1)
# Change colors in similar way
cl1<-recolorClusters(cl1, c("N"="red"),matchTo=c("name"))
clusterLegend(cl1)
}
