% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/io.R
\name{write.gctx}
\alias{write.gctx}
\alias{write_gctx}
\title{Write a GCT object to disk in GCTX format}
\usage{
write.gctx(...)

write_gctx(
  ds,
  ofile,
  appenddim = TRUE,
  compression_level = 0,
  matrix_only = FALSE,
  max_chunk_kb = 1024
)
}
\arguments{
\item{...}{arguments passed on to \code{write_gctx}}

\item{ds}{a GCT object}

\item{ofile}{the desired file path for writing}

\item{appenddim}{boolean indicating whether the
resulting filename will have dimensions appended
(e.g. my_file_n384x978.gctx)}

\item{compression_level}{integer between 1-9 indicating
how much to compress data before writing. Higher values
result in smaller files but slower read times.}

\item{matrix_only}{boolean indicating whether to write
only the matrix data (and skip row, column annotations)}

\item{max_chunk_kb}{for chunking, the maximum number of KB
a given chunk will occupy}
}
\value{
silently returns NULL
}
\description{
Write a GCT object to disk in GCTX format
}
\examples{
# note this will create a GCT file in your current directory
write_gctx(ds, "dataset")

}
\seealso{
Other GCTX parsing functions: 
\code{\link{GCT}},
\code{\link{append.dim}()},
\code{\link{fix.datatypes}()},
\code{\link{parse.gctx}()},
\code{\link{process_ids}()},
\code{\link{read.gctx.ids}()},
\code{\link{read.gctx.meta}()},
\code{\link{write.gctx.meta}()},
\code{\link{write.gct}()}
}
\concept{GCTX parsing functions}
