% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneInCluster.R
\name{geneInCluster}
\alias{geneInCluster}
\alias{geneInCluster,cogena-method}
\alias{geneInCluster,cogena_methods,cluster_methods}
\title{Get gene names in a certain cluster.}
\usage{
geneInCluster(object, method, nCluster, ith)

\S4method{geneInCluster}{cogena}(
  object,
  method = clusterMethods(object),
  nCluster = nClusters(object),
  ith
)
}
\arguments{
\item{object}{a cogena object}

\item{method}{a clustering method}

\item{nCluster}{cluster number}

\item{ith}{the i-th cluster (should no more than nCluster)}
}
\value{
a character vector containing the gene names.
}
\description{
Get gene names in a certain cluster. This is helpful if user want to get the
detail of a cluster.
}
\examples{
data(Psoriasis)
annofile <- system.file("extdata", "c2.cp.kegg.v7.01.symbols.gmt.xz", 
package="cogena")

\dontrun{
genecl_result <- coExp(DEexprs, nClust=2:3, clMethods=c("hierarchical","kmeans"), 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)

clen_res <- clEnrich(genecl_result, annofile=annofile, sampleLabel=sampleLabel)

#summay this cogena object
summary(clen_res)

#geneInCluster
g1 <- geneInCluster(clen_res, "kmeans", "3", "2")

#Up or Down genes with setting nCluster as "2".
g2 <- geneInCluster(clen_res, "kmeans", "2", "1")
}

}
\seealso{
\code{\link{clEnrich}}
}
