% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmapPEI.R
\docType{methods}
\name{heatmapPEI}
\alias{heatmapPEI}
\alias{heatmapPEI,cogena-method}
\alias{heatmapPEI,cogena}
\title{heatmap of the gene set enrichment from a cogena object.}
\usage{
heatmapPEI(
  object,
  method,
  nCluster,
  CutoffNumGeneset = 20,
  CutoffPVal = 0.05,
  orderMethod = "max",
  roundvalue = TRUE,
  low = "grey",
  high = "red",
  na.value = "white",
  maintitle = NULL,
  printGS = FALSE,
  add2 = TRUE,
  geom = "tile",
  wrap_with = 40
)

\S4method{heatmapPEI}{cogena}(
  object,
  method = clusterMethods(object),
  nCluster = nClusters(object),
  CutoffNumGeneset = 20,
  CutoffPVal = 0.05,
  orderMethod = "max",
  roundvalue = TRUE,
  low = "grey",
  high = "red",
  na.value = "white",
  maintitle = NULL,
  printGS = FALSE,
  add2 = TRUE,
  geom = "tile",
  wrap_with = 60
)
}
\arguments{
\item{object}{a genecl or cogena object}

\item{method}{as clMethods in genecl function}

\item{nCluster}{as nClust in cogena function.}

\item{CutoffNumGeneset}{the cut-off of the number of gene sets in the 
return table}

\item{CutoffPVal}{the cut-off of p-value. The default is 0.05.}

\item{orderMethod}{the order method, default is max, other options are 
"mean", "all", "I", "II" or a number meaning the ith cluster.}

\item{roundvalue}{The default is TRUE. whether or not round the data. 
such as round(1.54, 1)=1.5}

\item{low}{colour for low end of gradient.}

\item{high}{colour for high end of gradient.}

\item{na.value}{Colour to use for missing values.}

\item{maintitle}{a character. like GSExxx. the output of figure will like
"cogena: kmeans 3 GSExxx" in two lines. Default is NULL}

\item{printGS}{print the enriched gene set names or not. Default is FALSE}

\item{add2}{enrichment score for add Up and Down reuglated genes.}

\item{geom}{tile or circle}

\item{wrap_with}{default 40. wrap strings}
}
\value{
a gene set enrichment heatmap
}
\description{
heatmap of the gene set enrichment score. After obtaining the ennrichemt of 
clusters for each gene set, the heatmapPEI will show it as a heatmap in 
order. The value shown in heatmapPEI is the -log2(fdr), representing the
enrichment score.
}
\details{
The x-axis shows cluster i and the number of genes in cluster, with
red means cluster containing up-regulated genes, green means down-regulated
genes, black means there are up and 
down regulated genes in this cluster and blue means all DEGs. If parameter
add2 is true, another two columns will be shown as well, representing the
up and down regulated genes. 

The direction of DEGs are based on latter Vs
former from sample labels. For example, labels are 
as.factor(c("ct", "Disease")), the "Disease" are latter compared with "ct".
Usually, the order is the alphabet.

The y-axis represents the gene sets enriched.


orderMethod:
\itemize{
\item max. ordered by the max value in clusters beside all
\item mean. ordered by the mean value in clusters beside all
\item All. ordered by all genes
\item Up. ordered by up-regulated genes (add2 should be TRUE)
\item Down. ordered by down-regulated genes (add2 should be TRUE)
}
}
\examples{
data(Psoriasis)
annofile <- system.file("extdata", "c2.cp.kegg.v7.01.symbols.gmt.xz", 
package="cogena")

\dontrun{
genecl_result <- coExp(DEexprs, nClust=2:3, clMethods=c("hierarchical","kmeans"), 
    metric="correlation", method="complete", ncore=2, verbose=TRUE)

clen_res <- clEnrich(genecl_result, annofile=annofile, sampleLabel=sampleLabel)

#summay this cogena object
summary(clen_res)

#heatmapPEI
heatmapPEI(clen_res, "kmeans", "2")
heatmapPEI(clen_res, "kmeans", "2", orderMethod="mean")
heatmapPEI(clen_res, "kmeans", "3", CutoffNumGeneset=20, 
    low = "#132B43", high = "#56B1F7", na.value = "grey50")
}

}
\seealso{
\code{\link{clEnrich}} and \code{\link{heatmapCluster}}
}
