% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plot_orthofinder_stats}
\alias{plot_orthofinder_stats}
\title{Plot a panel with a summary of Orthofinder stats}
\usage{
plot_orthofinder_stats(tree = NULL, stats_list = NULL, xlim = c(0, 1))
}
\arguments{
\item{tree}{Tree object as returned by \code{treeio::read.*},
a family of functions in the \strong{treeio} package to import tree files
in multiple formats, such as Newick, Phylip, NEXUS, and others.
If your species tree was inferred with Orthofinder (using STAG), the tree
file is located in \emph{Species_Tree/SpeciesTree_rooted_node_labels.txt}.
Then, it can be imported with \code{treeio::read_tree(path_to_file)}.}

\item{stats_list}{(optional) A list of data frames with Orthofinder summary stats
as returned by the function \code{read_orthofinder_stats}. If this list
is given as input, nodes will be labeled with the number of duplications.}

\item{xlim}{Numeric vector of x-axis limits. This is useful if your
node tip labels are not visible due to margin issues. Default: c(0, 1).}
}
\value{
A panel of ggplot objects.
}
\description{
This function is a wrapper for \code{plot_species_tree},
\code{plot_duplications}, \code{plot_genes_in_ogs},
\code{plot_species_specific_ogs}.
}
\examples{
data(tree)
dir <- system.file("extdata", package = "cogeqc")
stats_list <- read_orthofinder_stats(dir)
plot_orthofinder_stats(tree, xlim = c(0, 1.5), stats_list = stats_list)
}
