% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/fateSelectionTest.R
\name{fateSelectionTest}
\alias{fateSelectionTest}
\alias{fateSelectionTest,matrix-method}
\alias{fateSelectionTest,SlingshotDataSet-method}
\alias{fateSelectionTest,SingleCellExperiment-method}
\alias{fateSelectionTest,PseudotimeOrdering-method}
\title{Differential fate selection Test}
\usage{
fateSelectionTest(cellWeights, ...)

\S4method{fateSelectionTest}{matrix}(
  cellWeights,
  conditions,
  global = TRUE,
  pairwise = FALSE,
  method = c("Classifier", "mmd", "wasserstein_permutation"),
  classifier_method = "rf",
  thresh = 0.01,
  args_classifier = list(),
  args_mmd = list(),
  args_wass = list()
)

\S4method{fateSelectionTest}{SlingshotDataSet}(
  cellWeights,
  conditions,
  global = TRUE,
  pairwise = FALSE,
  method = c("Classifier", "mmd", "wasserstein_permutation"),
  classifier_method = "rf",
  thresh = 0.01,
  args_classifier = list(),
  args_mmd = list(),
  args_wass = list()
)

\S4method{fateSelectionTest}{SingleCellExperiment}(
  cellWeights,
  conditions,
  global = TRUE,
  pairwise = FALSE,
  method = c("Classifier", "mmd", "wasserstein_permutation"),
  classifier_method = "rf",
  thresh = 0.01,
  args_classifier = list(),
  args_mmd = list(),
  args_wass = list()
)

\S4method{fateSelectionTest}{PseudotimeOrdering}(
  cellWeights,
  conditions,
  global = TRUE,
  pairwise = FALSE,
  method = c("Classifier", "mmd", "wasserstein_permutation"),
  classifier_method = "rf",
  thresh = 0.01,
  args_classifier = list(),
  args_mmd = list(),
  args_wass = list()
)
}
\arguments{
\item{cellWeights}{Can be either a \code{\link{SlingshotDataSet}}, a
\code{\link{SingleCellExperiment}} object or a matrix of cell weights
defining the probability that a cell belongs to a particular lineage.
Each row represents a cell and each column represents a lineage. If only a
single lineage, provide a matrix with one column containing all values of 1.}

\item{...}{parameters including:}

\item{conditions}{Either the vector of conditions, or a character indicating which
column of the metadata contains this vector}

\item{global}{If TRUE, test for all pairs simultaneously.}

\item{pairwise}{If TRUE, test for all pairs independently.}

\item{method}{One of "Classifier" or "mmd".}

\item{classifier_method}{The method used in the classifier test. Default to
"rf", i.e random forest.}

\item{thresh}{The threshold for the classifier test. See details.
Default to .05.}

\item{args_classifier}{arguments passed to the classifier test. See \code{\link{classifier_test}}.}

\item{args_mmd}{arguments passed to the mmd test. See \code{\link{mmd_test}}.}

\item{args_wass}{arguments passed to the wasserstein permutation test. See
\code{\link{wasserstein_permut}}.}
}
\value{
A data frame with 3 columns:
\itemize{
  \item *pair* for individual pairs, the lineages numbers. For global,
  \code{"All"}.
  \item *p.value* the pvalue for the test at the global or pair level
  \item *statistic* The classifier accuracy
}
}
\description{
Test whether or not the cell repartition between lineages is
independent of the conditions
}
\examples{
data('slingshotExample', package = "slingshot")
rd <- slingshotExample$rd
cl <- slingshotExample$cl
condition <- factor(rep(c('A','B'), length.out = nrow(rd)))
condition[110:139] <- 'A'
sds <- slingshot::slingshot(rd, cl)
fateSelectionTest(sds, condition)
}
