% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge_sds}
\alias{merge_sds}
\title{Merge slingshots datasets}
\usage{
merge_sds(..., mapping, condition_id = seq_len(ncol(mapping)), scale = FALSE)
}
\arguments{
\item{...}{Slingshot datasets}

\item{mapping}{a matrix, one column per dataset. Each row amounts to lineage mapping.}

\item{condition_id}{A vector of condition for each condition. Default to integer values
in order of appearance}

\item{scale}{If TRUE (default), lineages that are mapped are scaled to have the same
length.}
}
\value{
A modified slingshot dataset that can be used for downstream steps.
}
\description{
If trajectory inference needs to be manually done condition per condition,
this allows to merge them into one. It requires manual mapping of lineages.
}
\details{
The function assumes that each lineage in a dataset maps to exactly one lineage
in another dataset. Anything else needs to be done manually.
}
\examples{
data(list = 'slingshotExample', package = "slingshot")
if (!"cl" \%in\% ls()) {
  rd <- slingshotExample$rd
  cl <- slingshotExample$cl
}
sds <- slingshot::slingshot(rd, cl)
merge_sds(sds, sds, mapping = matrix(c(1, 2, 1, 2), nrow = 2))
}
