% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coreICA.R
\name{coreICA}
\alias{coreICA}
\title{Fast Independent Component Analysis for multi-run mode}
\usage{
coreICA(
  X,
  n.comp,
  preICA = NULL,
  alg.typ = c("parallel", "deflation"),
  fun = c("logcosh", "exp"),
  w.init = NULL,
  alpha = 1,
  row.norm = FALSE,
  maxit = 200,
  tol = 1e-04,
  verbose = FALSE
)
}
\arguments{
\item{X}{matrix with features in rows and samples in columns}

\item{n.comp}{number of components.}

\item{preICA}{output of `outICA()`. Default is NULL}

\item{alg.typ}{parameter for fastICA(). If alg.typ == "deflation" the 
components are extracted one at a time. If alg.typ == "parallel" the 
components are extracted simultaneously. Default value is "deflation"}

\item{fun}{the functional form of the G function used in the approximation 
to neg-entropy in fastICA. Default value is "logcosh"}

\item{w.init}{initial weights}

\item{alpha}{default is 1}

\item{row.norm}{set TRUE if the normalization by rows is needed. 
Default is FALSE}

\item{maxit}{default is 200}

\item{tol}{default is 1e-04}

\item{verbose}{logic TRUE or FALSE. Use TRUE for print process steps. 
Default value is FALSE}
}
\value{
a list with (compliant to `fastICA()`output)
        \item{X}{pre-processed data matrix}
        \item{K}{pre-whitening matrix that projects data onto the first 
       `n.comp` principal components}
        \item{W}{estimated un-mixing matrix}
        \item{A}{estimated mixing matrix}
        \item{S}{estimated source matrix}
}
\description{
Adaptation of \code{\link[fastICA]{fastICA}} for quick 
multiple-run calculations for consensus Independent Component Analysis (ICA)
}
\author{
Maryna Chepeleva
}
\keyword{internal}
