% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFeatures.R
\name{getFeatures}
\alias{getFeatures}
\title{Get features from consICA deconvolution result}
\usage{
getFeatures(cica, alpha = 0.05, sort = FALSE)
}
\arguments{
\item{cica}{list compliant to `consICA()` result}

\item{alpha}{value in [0,1] interval. Used to filter features with 
FDR < `alpha`. Default value is 0.05}

\item{sort}{sort features decreasing FDR. Default is FALSE}
}
\value{
list of dataframes `pos` for positive and `neg` for negative 
affecting features with columns:
    \item{features}{names of features}
    \item{fdr}{false discovery rate value}
}
\description{
Extract names of features (rows in `X` and `S` matrices) and
their false discovery rates values
}
\examples{
data("samples_data")
# Get deconvolution of X matrix
cica <-  consICA(samples_data, ncomp=10, ntry=1, show.every=0)
# Get features names and FDR for each component
features <- getFeatures(cica)
# Positive affecting features for first components are
ic1_pos <- features$ic.1$pos
}
\author{
Petr V. Nazarov
}
