% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findConsensusPeakRegionsIntern.R
\encoding{UTF-8}
\name{refineRegion}
\alias{refineRegion}
\title{Refine the selected region by using an iterative process.}
\usage{
refineRegion(peaks, setPeaks, extendingSize, region_width, currentPeak)
}
\arguments{
\item{peaks}{a \code{GRanges} containing all peaks from the current analysis
sorted by position.}

\item{setPeaks}{a \code{GRanges} containing the peaks present in the current
selected region.}

\item{extendingSize}{a \code{numeric} value indicating the size of padding
at each side of the peaks median position to create the consensus
region. The minimum size of the consensu region will be equal to
twice the value of the \code{extendingSize} parameter. The size of
the \code{extendingSize} must be a positive integer.}

\item{region_width}{a \code{numeric} value indicating the size of the
region which is equivalent to twice the \code{extendingSize}.}

\item{currentPeak}{a \code{GRanges} with 1 range containing the information
about the current peak used as the starting point for the selected region.}
}
\value{
an object of \code{class} "commonFeatures".
}
\description{
Find regions sharing the same features for a minimum number of
experiments using called peaks of signal enrichment based on
pooled, normalized data (mainly coming from narrowPeak files). Tje
analysis is limited to one chromosome.
The peaks and narrow peaks are used to identify
the consensus regions. The minimum number of experiments that must
have at least on peak in a region so that it is retained as a
consensus region is specified by user, as well as the size of
mining regions.
}
\author{
Astrid Deschênes
}
\keyword{internal}
