% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa-AllGenerics.R, R/methods.R
\docType{methods}
\name{coseqFullResults}
\alias{coseqFullResults}
\alias{clusters}
\alias{likelihood}
\alias{nbCluster}
\alias{proba}
\alias{ICL}
\alias{profiles}
\alias{tcounts}
\alias{transformationType}
\alias{model}
\alias{DDSEextract}
\alias{Djumpextract}
\alias{clusters,coseqResults-method}
\alias{clusters,RangedSummarizedExperiment-method}
\alias{likelihood,MixmodCluster-method}
\alias{likelihood,RangedSummarizedExperiment-method}
\alias{likelihood,coseqResults-method}
\alias{likelihood,NULL-method}
\alias{nbCluster,MixmodCluster-method}
\alias{nbCluster,RangedSummarizedExperiment-method}
\alias{nbCluster,coseqResults-method}
\alias{nbCluster,NULL-method}
\alias{ICL,RangedSummarizedExperiment-method}
\alias{ICL,MixmodCluster-method}
\alias{ICL,coseqResults-method}
\alias{ICL,NULL-method}
\alias{profiles,coseqResults-method}
\alias{tcounts,coseqResults-method}
\alias{transformationType,coseqResults-method}
\alias{show}
\alias{show,coseqResults-method}
\alias{model,coseqResults-method}
\alias{proba,MixmodCluster-method}
\alias{DDSEextract,Capushe-method}
\alias{Djumpextract,Capushe-method}
\alias{clusters,matrix-method}
\alias{clusters,data.frame-method}
\alias{coseqFullResults,coseqResults-method}
\title{Accessors for the assigned cluster labels of a coseqResults object.}
\usage{
coseqFullResults(object, ...)

clusters(object, ...)

likelihood(object, ...)

nbCluster(object, ...)

proba(object, ...)

ICL(object, ...)

profiles(object, ...)

tcounts(object, ...)

transformationType(object, ...)

model(object, ...)

DDSEextract(object, ...)

Djumpextract(object, ...)

\S4method{clusters}{coseqResults}(object, K)

\S4method{clusters}{RangedSummarizedExperiment}(object, ...)

\S4method{clusters}{matrix}(object, ...)

\S4method{clusters}{data.frame}(object, ...)

\S4method{likelihood}{MixmodCluster}(object)

\S4method{likelihood}{RangedSummarizedExperiment}(object)

\S4method{likelihood}{coseqResults}(object)

\S4method{likelihood}{`NULL`}(object)

\S4method{nbCluster}{MixmodCluster}(object)

\S4method{nbCluster}{RangedSummarizedExperiment}(object)

\S4method{nbCluster}{coseqResults}(object)

\S4method{nbCluster}{`NULL`}(object)

\S4method{ICL}{MixmodCluster}(object)

\S4method{ICL}{RangedSummarizedExperiment}(object)

\S4method{ICL}{coseqResults}(object)

\S4method{ICL}{`NULL`}(object)

\S4method{profiles}{coseqResults}(object)

\S4method{tcounts}{coseqResults}(object)

\S4method{transformationType}{coseqResults}(object)

\S4method{model}{coseqResults}(object)

\S4method{coseqFullResults}{coseqResults}(object)

\S4method{show}{coseqResults}(object)

\S4method{proba}{MixmodCluster}(object)

\S4method{DDSEextract}{Capushe}(object)

\S4method{Djumpextract}{Capushe}(object)
}
\arguments{
\item{object}{a \code{coseqResults}, \code{RangedSummarizedExperiment}, or
\code{MixmodCluster} object.}

\item{...}{Additional optional parameters}

\item{K}{numeric indicating the model to be used (if NULL of missing, the model chosen
by ICL is used by default)}
}
\value{
Output varies depending on the method. \code{clusters} returns a vector of cluster
labels for each gene for the desired model.
}
\description{
The counts slot holds the count data as a matrix of non-negative integer
count values, one row for each observational unit (gene or the like), and one
column for each sample.
}
\examples{
## Simulate toy data, n = 300 observations
set.seed(12345)
countmat <- matrix(runif(300*4, min=0, max=500), nrow=300, ncol=4)
countmat <- countmat[which(rowSums(countmat) > 0),]
conds <- rep(c("A","B","C","D"), each=2)

## Run the Normal mixture model for K = 2,3,4
run_arcsin <- coseq(object=countmat, K=2:4, iter=5, transformation="arcsin",
                    model="Normal", seed=12345)
run_arcsin

## Plot and summarize results
plot(run_arcsin)
summary(run_arcsin)

## Compare ARI values for all models (no plot generated here)
ARI <- compareARI(run_arcsin, plot=FALSE)

## Compare ICL values for models with arcsin and logit transformations
run_logit <- coseq(object=countmat, K=2:4, iter=5, transformation="logit",
                   model="Normal")
compareICL(list(run_arcsin, run_logit))

## Use accessor functions to explore results
clusters(run_arcsin)
likelihood(run_arcsin)
nbCluster(run_arcsin)
ICL(run_arcsin)

## Examine transformed counts and profiles used for graphing
tcounts(run_arcsin)
profiles(run_arcsin)

## Run the K-means algorithm for logclr profiles for K = 2,..., 20
run_kmeans <- coseq(object=countmat, K=2:20, transformation="logclr",
                    model="kmeans")
run_kmeans
}
\author{
Andrea Rau
}
