% Generated by roxygen2 (4.0.1): do not edit by hand
\name{createArrayData}
\alias{createArrayData}
\title{Create a GRanges Object for a GWAS data.frame}
\usage{
createArrayData(arrayData, positionName = NULL,
  chromosomeName = "chromosome", chromosomeNameConvention = "NCBI",
  verbose = TRUE)
}
\arguments{
\item{arrayData}{A data.frame containing array data from
which the \code{GRanges} object will be created. This object is expected
to include the position and chromosome, along with a SNP
identifier and corresponding p-value.}

\item{positionName}{The name of the column in the filepathData
object that holds position data for each probe. By default, this
value is NULL and there are columns Start and End which hold
this information.}

\item{chromosomeName}{The name of the column in the filepathData
object that holds chromosome data for each probe. By default,
this value is \code{chromosome}.}

\item{chromosomeNameConvention}{The naming convention used for the
chromosomes, either \code{NCBI} (default), \code{UCSC}, or a user
specified mapping. By default, this is \code{NCBI}, indicating the autosomes
are stored as integers and the mitochondrial and sex chromosomes are stored
as \code{MT} and \code{X, Y}, respectively. The \code{UCSC} naming
convention appends "chr" to each chromosome, and the mitochondrial coding is
"chrM." Alternatively, a user can supply the mapping from each chromosome
to the UCSC naming convention in the form of a character vector where the
elements are the UCSC names and the corresponding names of the elements are
the current chromosome names. An `NA' chromosome will be mapped to unknown.
For more information, please see the \code{GenomeInfoDb} BioConductor R package.}

\item{verbose}{A logical argument indicating whether output
should be printed. The default is FALSE.}
}
\value{
A GRanges object.
}
\description{
Creates a GRanges object used for SNP set analysis.
}
\details{
This function takes a data.frame and creates a GRanges
object used for SNP set analysis.
}
\author{
Jason Hackney, Jessica Larson, Caitlin McHugh
\email{mchughc@uw.edu}
}
\examples{
    data(geneSetAnalysis)
    head(geneSetAnalysis$arrayData)
    arrayDataGR <- createArrayData(geneSetAnalysis[["arrayData"]], positionName="Position")
}
\keyword{methods}

