% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/addDistanceToTss.R
\name{addDistanceToTss}
\alias{addDistanceToTss}
\alias{addDistanceToTss,GuideSet-method}
\alias{addDistanceToTss,PairedGuideSet-method}
\title{Add distance to TSS for a specificed TSS id}
\usage{
addDistanceToTss(object, ...)

\S4method{addDistanceToTss}{GuideSet}(object, tss_id)

\S4method{addDistanceToTss}{PairedGuideSet}(object, tss_id)
}
\arguments{
\item{object}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{...}{Additional arguments, currently ignored.}

\item{tss_id}{String specifiying TSS id to calculate the distance.
The column \code{tssAnnotation(object)$tss_id} will be used
to search for the TSS id.}
}
\value{
A A \linkS4class{GuideSet} object or a 
    \linkS4class{PairedGuideSet} object with an additional
    metadata column called \code{distance_to_tss} reporting
    the distance (in nucleotides) between the TSS position
    of the TSS specified by \code{tss_id} and the protospacer
    position. The \code{pam_site} coordinate is used as the representative
    position of protospacer sequences. 

    Note that a TSS annotation must be available in the \code{object}.
    A TSS annotation can be added using \code{addTssAnnotation}.
}
\description{
Add distance to TSS for a specificed TSS id.
}
\examples{
data(guideSetExampleFullAnnotation)
tss_id <- "ENSG00000120645_P1"
gs <- guideSetExampleFullAnnotation
gs <- addDistanceToTss(gs, tss_id)

}
\seealso{
\code{\link{addTssAnnotation}} to add TSS annotation.
}
\author{
Jean-Philippe Fortin
}
