% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addExonTable.R
\name{addExonTable}
\alias{addExonTable}
\title{Add a gene-specific exon table to a 
     \linkS4class{GuideSet} object.}
\usage{
addExonTable(
  guideSet,
  gene_id,
  txObject,
  valueColumn = "percentCDS",
  useConsensusIsoform = FALSE
)
}
\arguments{
\item{guideSet}{A \linkS4class{GuideSet} object or a 
\linkS4class{PairedGuideSet} object.}

\item{gene_id}{String specifying gene ID.}

\item{txObject}{A \linkS4class{TxDb} object or a
\linkS4class{GRangesList} object obtained using
\code{\link{TxDb2GRangesList}} to provide a 
gene model annotation.}

\item{valueColumn}{String specifying column in
\code{geneAnnotation(guideSet)} to use as values in the 
output exon table.}

\item{useConsensusIsoform}{Should a consensus isoform be used to 
annotate exons? FALSE by default. If TRUE, the isoform constructed
by \code{getConsensusIsoform} will be used.}
}
\value{
A \linkS4class{GuideSet} object with a "exonTable" DataFrame
    stored in \code{mcols(guideSet)}. The entries in the DataFrame
    correspond to the values specified by \code{valueColumn}.
    Rows correspond to gRNAs in the GuideSet, columns correspond to 
    all exons found in \code{txObject} for gene specified by
    \code{gene_id}.
}
\description{
Add a gene-specific exon table to a 
     \linkS4class{GuideSet} object.

Add a gene-specific exon table to a 
     \linkS4class{GuideSet} object.
}
\examples{
if (interactive()){
    data(guideSetExample, package="crisprDesign")
    data(grListExample, package="crisprDesign")
    guideSet <- addGeneAnnotation(guideSetExample,
                                  txObject=grListExample)
    guideSet <- addExonTable(guideSet,
                             gene_id="ENSG00000120645",
                             txObject=grListExample)

    guideSet$exonTable
}

}
\seealso{
\code{\link{addGeneAnnotation}} to add gene annotation and
    \code{\link{addTxTable}} to add a transcript table.
}
\author{
Jean-Philippe Fortin
}
