% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completeSpacers.R
\name{completeSpacers}
\alias{completeSpacers}
\alias{getPAMSequence}
\alias{getSpacerSequence}
\alias{getPAMSiteFromStartAndEnd}
\title{Get complete spacer information}
\usage{
getPAMSequence(chr, pam_site, strand, crisprNuclease = NULL, bsgenome = NULL)

getSpacerSequence(
  chr,
  pam_site,
  strand,
  crisprNuclease = NULL,
  bsgenome = NULL,
  spacerLen = NULL
)

getPAMSiteFromStartAndEnd(
  start = NULL,
  end = NULL,
  strand,
  crisprNuclease = NULL,
  spacerLen = NULL
)
}
\arguments{
\item{chr}{The chromosome in which the protospacer sequence is located.}

\item{pam_site}{Coordinate of the first nucleotide of the PAM sequence.}

\item{strand}{Either "+" or "-".}

\item{crisprNuclease}{A \linkS4class{CrisprNuclease} object.}

\item{bsgenome}{A \linkS4class{BSgenome} object.}

\item{spacerLen}{Spacer sequence length.
If NULL, the information is obtained from \code{crisprNuclease}.}

\item{start}{Coordinate of the first nucleotide of the spacer sequences.
Must be always less than \code{end}.}

\item{end}{Coordinate of the last nucleotide of the spacer sequence.
Must be always greater than \code{start}.}
}
\value{
A numeric or character vector, depending on the function.

\code{getPAMSequence} returns a character vector of PAM sequences.

\code{getSpacerSequence} returns a character vector of
    spacer sequences.
}
\description{
These functions serve to "fill-in-the-blank" for
    spacers lacking information.
}
\details{
Functions that return coordinates (\code{getPAMSite},
    \code{getCutSite}, \code{getSpacerRanges}) do not check whether
    coordinates exceed chromosomal lengths.

The start and end coordinates of a genomic range is
    strand-independent, and always obeys \code{start <= end}.
}
\examples{
if (requireNamespace("BSgenome.Hsapiens.UCSC.hg38")){
library(BSgenome.Hsapiens.UCSC.hg38)
bsgenome <- BSgenome.Hsapiens.UCSC.hg38
dat <- data.frame(chr='chr4', start=1642343, strand='+')
dat$pam_site <- getPAMSiteFromStartAndEnd(start=dat$start,
                                          strand=dat$strand)
dat$pam <- getPAMSequence(chr=dat$chr,
                          pam_site=dat$pam_site,
                          strand=dat$strand,
                          bsgenome=bsgenome)
dat$spacer <- getSpacerSequence(chr=dat$chr,
                                pam_site=dat$pam_site,
                                strand=dat$strand,
                                bsgenome=bsgenome)
}
}
