% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/completeSpacers.R
\name{convertToMinMaxGRanges}
\alias{convertToMinMaxGRanges}
\title{Convert a GuideSet object into a GRanges containing the range of 
    all targeting gRNAs.}
\usage{
convertToMinMaxGRanges(guideSet, anchor = c("cut_site", "pam_site"))
}
\arguments{
\item{guideSet}{A \linkS4class{GuideSet} object.}

\item{anchor}{A character string specifying which gRNA-specific coordinate
to use (\code{cut_site} or \code{pam_site}) when definining the min
and max coordinates of \linkS4class{GuideSet} object.}
}
\value{
A GRanges object with start and end coordinates
    corresponding to the minimum and maximum coordinates of the GuideSet
    object sites defined by \code{anchor}.
}
\description{
Convert a GuideSet object into a GRanges object containing 
   the minimum and maximum coordinates for all targeting gRNAs.
}
\examples{
data(guideSetExample, package="crisprDesign")
gr <- convertToMinMaxGRanges(guideSetExample)

}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
