% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findSpacers.R
\name{findSpacers}
\alias{findSpacers}
\title{Find CRISPR gRNA spacer sequences from a set of DNA sequences.}
\usage{
findSpacers(
  x,
  crisprNuclease = NULL,
  bsgenome = NULL,
  canonical = TRUE,
  both_strands = TRUE,
  spacer_len = NULL,
  strict_overlap = TRUE,
  remove_ambiguities = TRUE,
  remove_duplicates = TRUE
)
}
\arguments{
\item{x}{Either a \linkS4class{GRanges}, a \linkS4class{DNAStringSet}, or a
\linkS4class{DNAString} object, or a character vector of genomic
sequences. See details.}

\item{crisprNuclease}{A \linkS4class{CrisprNuclease} object.}

\item{bsgenome}{A \linkS4class{BSgenome} object from which to extract
sequences if \code{x} is a \linkS4class{GRanges} object.}

\item{canonical}{Whether to return only guide sequences having canonical
PAM sequences. If TRUE (default), only PAM sequences with the highest
weights stored in the \code{crisprNuclease} object will be considered.}

\item{both_strands}{Whether to consider both strands in search for 
protospacer sequences. \code{TRUE} by default.}

\item{spacer_len}{Length of spacers to return, if different from the
default length specified by \code{crisprNuclease}.}

\item{strict_overlap}{Whether to only include gRNAs that cut in the input
range, as given by \code{cut_site} (\code{TRUE}) or to include all
gRNAs that share any overlap with the input range (\code{FALSE}).
\code{TRUE} by default. Ignored when \code{x} is not a
\linkS4class{GRanges} object.}

\item{remove_ambiguities}{Whether to remove spacer sequences that contain
ambiguous nucleotides (not explicily \code{A}, \code{C}, \code{G}, or
\code{T}). TRUE by default.}

\item{remove_duplicates}{Whether to remove duplicated protospacer sequences
originating from overlapping genomic ranges. TRUE by default.}
}
\value{
A \linkS4class{GuideSet} object.
}
\description{
Returns all possible, valid gRNA sequences for a given CRISPR
   nuclease from either a \linkS4class{GRanges} object or a set of
   sequence(s) contained in either a \linkS4class{DNAStringSet},
   \linkS4class{DNAString} or character vector of genomic sequences.
}
\details{
If \code{x} is a \linkS4class{GRanges} object then a
    \linkS4class{BSgenome} must be supplied to \code{bsgenome}, from which
    the genomic sequence is obtained, unless the \code{bsgenome} can be
    inferred from \code{genome(x)}, for example, \code{"hg38"}. Otherwise,
    all supplied sequences are treated as the \code{"+"} strands of
    chromosomes in a \code{"custom"} genome.
    
    Ranges or sequences in \code{x} may contain names where permitted. These
    names are stored in \code{region} in the \code{mcols} of the output,
    and as \code{seqnames} of the output if \code{x} is not a
    \linkS4class{GRanges} object. If not \code{NULL}, \code{names(x)} must
    be unique, otherwise ranges or sequences are enumerated with the
    \code{"region_"} prefix.
    
    When \code{x} is a \linkS4class{GRanges}, the \code{*} strand is
    interpreted as both strands. Consequently, the \code{both_strands}
    argument has no effect on such ranges.
}
\examples{
# Using custom sequence as input:
my_seq <- c(my_seq="CCAANAGTGAAACCACGTCTCTATAAAGAATACAAAAAATTAGCCGGGTGTTA")
guides <- findSpacers(my_seq)

# Exon-intro region of human KRAS specified 
# using a GRanges object:
library(GenomicRanges)
library(BSgenome.Hsapiens.UCSC.hg38)
bsgenome <- BSgenome.Hsapiens.UCSC.hg38

gr_input <- GRanges(c("chr12"),
                    IRanges(start=25224014, end=25227007))
guideSet <- findSpacers(gr_input, bsgenome=bsgenome)

# Designing guides for enAsCas12a nuclease:
data(enAsCas12a, package="crisprBase")
guideSet <- findSpacers(gr_input, 
                        canonical=FALSE,
                        bsgenome=bsgenome,
                        crisprNuclease=enAsCas12a)

}
\author{
Jean-Philippe Fortin, Luke Hoberecht
}
