% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCrispraterScores.R
\name{getCRISPRaterScores}
\alias{getCRISPRaterScores}
\title{Calculate on-target sgRNA activity scores for Cas9 using CRISPRater}
\usage{
getCRISPRaterScores(sequences)
}
\arguments{
\item{sequences}{Character vector of 20bp protospacer sequences.}
}
\value{
\strong{getCrisprRaterScores} returns a data.frame with
    \code{sequence} and \code{score} columns. The CRISPRater score takes on
    a value between 0 and 1. A higher score indicates higher knockout 
    efficiency.
}
\description{
Calculate on-target sgRNA activity scores for 
    CRISPR/Cas9-induced knockout using the DeepHF scoring method. Both U6
    and T7 promoters are supported. Three different versions of the SpCas9
    nuclease are supported: wildtype (WT-SpCas9), high-fidelity Cas9
    (SpCas9-HF1) and enhanced Cas9 (eSpCas9). Currently not supported
    on Windows machines.
}
\details{
Input sequences for CRISPRater scoring must be 20 spacer sequences.
}
\examples{
spacer  <- "ATCGATGCTGATGCTAGATA" #20bp
results <- getCRISPRaterScores(spacer)

}
\references{
Labuhn M, Adams FF, Ng M, et al. Refined sgRNA efficacy prediction improves
large-and small-scale CRISPR–Cas9 applications. Nucleic acids research. 2018
Feb 16;46(3):1375-85.
}
\author{
Jean-Philippe Fortin
}
