% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCasRxRFScores.R
\name{getCasRxRFScores}
\alias{getCasRxRFScores}
\title{Calculate on-target sgRNA activity scores for CasRx using CasRx-RF}
\usage{
getCasRxRFScores(
  mrnaSequence,
  directRepeat = "aacccctaccaactggtcggggtttgaaac",
  binaries = NULL,
  sort = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{mrnaSequence}{A \code{DNAStringSet} represeting the mRNA sequence
for which to extract spacer sequences and calculate scores.}

\item{directRepeat}{String specifying the direct repeat used in the 
CasRx construct.}

\item{binaries}{Named list of paths for binaries needed for 
CasRx-RF. Names of the list must be "RNAfold", "RNAhybrid",
and "RNAplfold". Each list element is a string specifying
the path of the binary. If NULL (default), binaries must be
available on the PATH.}

\item{sort}{Should spacers be sorted by score? FALSE by default.}

\item{verbose}{Should messages be printed to console? TRUE by default.}
}
\value{
A data.frame with the following columns:
\itemize{
\item \code{ID} Character vector specifying spacer ID.
\item \code{spacer} 23-mer spacer sequence.
\item \code{pfs_site} coordinate of the protospacer flanking sequence (PFS).
\item \code{protospacer} 23-mer protospacer sequence (reverse complement of the spacer sequence).
\item \code{PFS} PFS nucleotide.
\item \code{score} Raw score (not standardized).
\item \code{standardizedScore} Score standardized between 0 and 1.
\item \code{quartile} Quartile score (1 to 4, with 4 being the best quartile.
}

A scores closer to 1 indicates higher predicted on-target activity.
}
\description{
Calculate on-target sgRNA activity scores 
    for CasRx (RfxCas13d) using the CasRx-RF algorithm.
}
\details{
The function first extracts all 23mer spacer sequences targeting
   the mRNA sequence, and scores them for on-target activity.
}
\examples{

if (interactive()){
    fasta <- file.path(system.file(package="crisprScore"),
        "casrxrf/test.fa")
    mrnaSequence <- Biostrings::readDNAStringSet(filepath=fasta,
        format="fasta",
        use.names=TRUE)
    results <- getCasRxRFScores(mrnaSequence)
}

}
\references{
Wessels HH, Méndez-Mancilla A, Guo X, et al.
Massively parallel Cas13 screens reveal principles 
for guide RNA design. Nat biotechnol. 2020 Jun;38(6):722-7.
}
\author{
Jean-Philippe Fortin
}
