% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCrispraiScores.R
\name{getCrispraiScores}
\alias{getCrispraiScores}
\title{Calculate on-target sgRNA activity scores for CRISPRa and CRISPRi}
\usage{
getCrispraiScores(
  tss_df,
  sgrna_df,
  verbose = FALSE,
  modality = c("CRISPRa", "CRISPRi"),
  fastaFile = NULL,
  chromatinFiles = NULL
)
}
\arguments{
\item{tss_df}{A \code{data.frame} specifying coordinates of transcription
start site (TSS) of the targeted promoter regions.
Must have the following columns: \code{gene_symbol},
\code{promoter}, \code{transcripts}, \code{position}, \code{strand}, and
\code{chr}. See details section below for more information.}

\item{sgrna_df}{A \code{A data.frame} specifying coordinates and spacer
sequences of the sgRNAs to score.  Must have the following columns:
\code{grna_id}, \code{tss_id}, \code{pam_site}, \code{strand}, and
\code{spacer_19mer}. See details section below for more information.}

\item{verbose}{Should messages be printed to the console?
TRUE by default.}

\item{modality}{Which mode of perturbation is being used? Must be a
\code{string} specifying either \code{CRISPRa} or \code{CRISPRi}.}

\item{fastaFile}{String specifying fasta file of the hg38 genome.}

\item{chromatinFiles}{Named character vector of length 3 specifying
BigWig files containing chromatin accessibility data.}
}
\value{
\strong{getCrispraiScores} returns a \code{data.frame} with
\code{grna_id} and \code{score} columns. The Weissman score takes on a
value between 0 and 1. A higher score indicates higher sgRNA efficiency.
}
\description{
Use the Weissman lab scoring method (library design v2) to
calculate on-target sgRNA  activity scores for Cas9-based CRISPR
activation (CRISPRa) and CRISPR inactivation (CRISPRi) gene perturbation
studies. The algorithm incorporates chromatin features, transcription
start site, and sequence to predict gRNA activity scores.
Only sgRNAs designed for the human genome (hg38 build) using Cas9 are
supported at the moment, and only spacers of length 19 are
supported at the moment.
}
\details{
\code{tss_df} details:
This must be a \code{data.frame} that contains the following columns:
* tss_id: string specifying name of the TSS.
* gene_symbol: string specifying sHGNC/HUGO gene identifier.
* promoter: string specifying promoter ID (e.g. "P1" or "P2").
* transcripts: Ensembl transcript identifier.
* position: start position of TSS in hg38 coordinates.
* strand: strand of the gene/TSS. Must be either \emph{+} or \emph{-}.
* chr: string specifying chromosome (e.g. "chr1").

\code{sgrna_df} details:
This must be a \code{data.frame} that contains the following columns:
* grna_id: string specifying a unique sgRNA identifier.
* tss_id: string specifying name of the TSS.
* pam_site: genomic ccoordinate of the \strong{N} in the \emph{NGG} PAM sequence.
* strand: strand fo the sgRNA. Must be either \emph{+} or \emph{-}.
* spacer_19mer: string specifying sgRNA 19mer spacer sequence.
}
\examples{
\dontrun{
results <- getCrispraiScores(tss_df=tssExampleCrispra,
                             sgrna_df=sgrnaExampleCrispra,
                             modality="CRISPRa")

results <- getCrispraiScores(tss_df=tssExampleCrispri,
                             sgrna_df=sgrnaExampleCrispri,
                             modality="CRISPRi")
}

}
\references{
Horlbeck et al. Compact and highly active next-generation libraries for
CRISPR-mediated gene repression and activation
eLife 2016;5:e19760.
\url{https://doi.org/10.7554/eLife.19760}.
}
\author{
Pirunthan Perampalam, Jean-Philippe Fortin
}
