% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLindelScores.R
\name{getLindelScores}
\alias{getLindelScores}
\title{Predict frameshift ratios from CRISPR/Cas9 indel prediction using
    Lindel}
\usage{
getLindelScores(sequences, fork = FALSE)
}
\arguments{
\item{sequences}{Character vector of 65bp sequences needed for Lindel
scoring, see details below.}

\item{fork}{Set to \code{TRUE} to preserve changes to the R
configuration within the session.}
}
\value{
A data.frame with predicted frameshift ratio (between 0 and 1).
    A higher ratio indicates a greater chance of a frameshift indel
    introduced by CRISPR/Cas9-induced double-strand breaks.
}
\description{
Predict frameshift ratios from CRISPR/Cas9 indel prediction
    using the Lindel prediction algorithm.
}
\details{
The input sequences for Lindel scoring require 13 nucleotides
    upstream of the protospacer sequence, the protospacer sequence
    itself (23 nucleotides) and 29 nucleootides downstream of the protospacer
    sequence, for a total of 65 nucleotides. Note that only canonical PAM
    sequences (NGG) are accepted by Lindel.
}
\examples{
if (interactive()){
flank5 <- "ACCTTTTAATCGA" #13bp
spacer <- "TGCTGATGCTAGATATTAAG" #20bp
pam    <- "TGG" #3bp
flank3 <- "CTTTTAATCGATGCTGATGCTAGATATTA" #29bp
input <- paste0(flank5, spacer, pam, flank3)
results <- getLindelScores(input)
}
}
\references{
Wei Chen, Aaron McKenna, Jacob Schreiber, Maximilian Haeussler, Yi Yin,
    Vikram Agarwal, William Stafford Noble, Jay Shendure, Massively parallel
    profiling and predictive modeling of the outcomes of CRISPR/Cas9-mediated
    double-strand break repair, Nucleic Acids Research, Volume 47, Issue 15,
    05 September 2019, Pages 7989–8003,
    \url{https://doi.org/10.1093/nar/gkz487}.
}
\author{
Jean-Philippe Fortin
}
