% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRuleSet3Scores.R
\name{getRuleSet3Scores}
\alias{getRuleSet3Scores}
\title{Calculate on-target sgRNA activity scores for SpCas9 using Rule Set 3}
\usage{
getRuleSet3Scores(
  sequences,
  tracrRNA = c("Hsu2013", "Chen2013"),
  mode = c("sequence", "target")
)
}
\arguments{
\item{sequences}{Character vector of 30bp sequences needed for Rule Set 3
scoring, see details below.}

\item{tracrRNA}{String specifying which tracrRNA is used. 
Must be either "Hsu2013" (default) or "Chen2013".}

\item{mode}{String specifying which prediction mode is used.
Must be either "sequence" (default) or "target".}
}
\value{
\strong{getRuleSet3Scores} returns a data.frame with
    \code{sequence} and \code{score} columns. The getRuleSet3Scores score
    is similar to a Z-score.A higher score indicates higher
    knockout efficiency.
}
\description{
Calculate on-target sgRNA activity scores for
    CRISPR/Cas9-induced knockout using the Rule Set 3 scoring method.
}
\details{
The input sequences for Rule Set 3 scoring require 4 nucleotides
    upstream of the protospacer sequence, the protospacer sequence
    itself (20bp spacer sequence + 3bp PAM sequence ) and 3 nucleootides 
    downstream of the protospacer sequence, for a total of 30 nucleotides.
}
\examples{

if (interactive()){
flank5 <- "ACCG" #4bp
spacer <- "AATCGATGCTGATGCTAGAT" #20bp
pam    <- "AGG" #3bp
flank3 <- "AAT" #3bp
input  <- paste0(flank5, spacer, pam, flank3) 
results <- getRuleSet3Scores(input)
}

}
\references{
doi: https://doi.org/10.1101/2022.06.27.497780
}
\author{
Jean-Philippe Fortin
}
