% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGuideSet.R
\name{plotGuideSet}
\alias{plotGuideSet}
\title{Plotting a GuideSet and other genomic annotations}
\usage{
plotGuideSet(
  x,
  geneModel = NULL,
  targetGene = NULL,
  annotations = list(),
  from = NULL,
  to = NULL,
  extend.left = 0,
  extend.right = 0,
  margin = 1,
  includeIdeogram = TRUE,
  bands = NULL,
  guideStacking = "squish",
  bsgenome = NULL,
  pamSiteOnly = FALSE,
  showGuideLabels = TRUE,
  onTargetScore = NULL,
  includeSNPTrack = TRUE,
  gcWindow = NULL
)
}
\arguments{
\item{x}{A \linkS4class{GuideSet} object.}

\item{geneModel}{A \linkS4class{TxDb} object or a \linkS4class{GRangesList}
object obtained using \link[crisprDesign]{TxDb2GRangesList}.}

\item{targetGene}{String specifying the gene symbol or Ensembl ID of
the gene to plot.}

\item{annotations}{A named (optional) list of genomic annotations as
\linkS4class{GRanges} to plot. Provided names are displayed as track
titles.}

\item{from, to}{Numeric value giving the genomic coordinate range to plot;
see \link[Gviz]{plotTracks}.}

\item{extend.left, extend.right}{Numeric value giving the length in bases to
extend the plotting range; see \link[Gviz]{plotTracks}.}

\item{margin}{A numeric value that sets the margin of the plotting range
with respect to the range of \code{x}. The value is a ratio of the width
of \code{x} considered as a single range, with a value of \code{1}
(default) extending the plotting window by the same distance as that
between \code{min(start(x))} and \code{max(end(x))}. Only works for the
respective side of the plot if either \code{from} or \code{to} are
\code{NULL}.}

\item{includeIdeogram}{Logical; whether to include an
\link[Gviz]{IdeogramTrack} in the plot.}

\item{bands}{A \code{data.frame} of cytoband information for the
target genome required for ideogram plotting; see
\link[Gviz]{IdeogramTrack}.}

\item{guideStacking}{Character string specifying how to stack guides.
Options are \code{squish}, \code{dense}, \code{hide} (see
\link[Gviz]{GeneRegionTrack}), or \code{NA} to have each guide occupy a
separate track.}

\item{bsgenome}{A \linkS4class{BSgenome} object; used to generate
\link[Gviz]{SequenceTrack} and GC content \link[Gviz]{DataTrack}.}

\item{pamSiteOnly}{Whether to plot only the PAM site in representing guides,
or plot the full guide and PAM sequence (default).}

\item{showGuideLabels}{Logical; whether to show labels for individual guides.}

\item{onTargetScore}{Optional column name in \code{mcols(x)} of on-target
scores. Applies a color scheme to the guide track based on on-target
scores, with light gray corresponding to 0 and dark blue corresponding
to 1.}

\item{includeSNPTrack}{Logical; whether to include an
\link[Gviz]{AnnotationTrack} for SNPs if such annotation exists in
\code{x}.}

\item{gcWindow}{If not \code{NULL}, a numeric value specifying the distance
from a given base for which to establish a window for calculating GC
content at that base. These values are then added to the plot in a
\link[Gviz]{DataTrack}.}
}
\value{
A Gviz plot; see \link[Gviz]{plotTracks}.
}
\description{
Function to plot guide targets stored in a
\linkS4class{GuideSet} object in a gene browser view supported by
\code{Gviz}. Target gene isoforms and other genomic annotation,
along with the target chromosome ideogram and sequence, may also be
added, permitting a comprehensive visualization of the genomic context
around the target protospacer sequences.
}
\examples{
if (interactive()){
data(krasGuideSet, package="crisprViz")
data(krasGeneModel, package="crisprViz")
plotGuideSet(krasGuideSet[1:4],
             geneModel=krasGeneModel,
             targetGene="KRAS")
}

}
\seealso{
\link{plotMultipleGuideSets} for plotting multiple GuideSet objects
together.
}
\author{
Luke Hoberecht
}
