% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMultipleGuideSets.R
\name{plotMultipleGuideSets}
\alias{plotMultipleGuideSets}
\title{Plotting a GuideSet and other genomic annotation}
\usage{
plotMultipleGuideSets(
  x,
  geneModel = NULL,
  targetGene = NULL,
  annotations = list(),
  from = NULL,
  to = NULL,
  extend.left = 0,
  extend.right = 0,
  margin = 1,
  includeIdeogram = TRUE,
  bands = NULL,
  bsgenome = NULL,
  onTargetScores = NULL,
  includeSNPTrack = TRUE,
  gcWindow = NULL
)
}
\arguments{
\item{x}{A named (optional) list of \linkS4class{GuideSet} objects. List
names are displayed as track titles.}

\item{geneModel}{A \linkS4class{TxDb} object or a \linkS4class{GRangesList}
object obtained using \link[crisprDesign]{TxDb2GRangesList}.}

\item{targetGene}{A character string giving the gene symbol or Ensembl ID of
the gene to plot.}

\item{annotations}{A named (optional) list of genomic annotations as
\linkS4class{GRanges} to plot. Provided names are displayed as track
titles.}

\item{from, to}{Numeric value giving the genomic coordinate range to plot;
see \link[Gviz]{plotTracks}.}

\item{extend.left, extend.right}{Numeric value giving the length in bases to
extend the plotting range; see \link[Gviz]{plotTracks}.}

\item{margin}{A numeric value that sets the margin of the plotting range
with respect to the range of \code{x}. The value is a ratio of the width
of \code{x} considered as a single range, with a value of \code{1}
(default) extending the plotting window by the same distance as that
between \code{min(start(x))} and \code{max(end(x))}. Only works for the
respective side of the plot if either \code{from} or \code{to} are
\code{NULL}.}

\item{includeIdeogram}{Logical; whether to include an
\link[Gviz]{IdeogramTrack} in the plot.}

\item{bands}{A \code{data.frame} of cytoband information for the
target genome required for ideogram plotting; see
\link[Gviz]{IdeogramTrack}.}

\item{bsgenome}{A \linkS4class{BSgenome} object; used to generate
\link[Gviz]{SequenceTrack} and GC content \link[Gviz]{DataTrack}.}

\item{onTargetScores}{Optional list of column names for each element in
\code{x} of on-target scores. Applies a color scheme to the guide track
based on on-target scores, with light gray corresponding to 0 and dark
blue corresponding to 1.}

\item{includeSNPTrack}{Logical; whether to include an
\link[Gviz]{AnnotationTrack} for SNPs if such annotation exists in
\code{x}.}

\item{gcWindow}{If not \code{NULL}, a numeric value specifying the distance
from a given base for which to establish a window for calculating GC
content at that base. These values are then added to the plot in a
\link[Gviz]{DataTrack}.}
}
\value{
A Gviz plot; see \code{\link[Gviz]{plotTracks}}.
}
\description{
Function to plot guide targets stored in multiple
\linkS4class{GuideSet} objects in a gene browser view supported by
\code{Gviz}. Target gene isoforms and other genomic annotation,
along with the target chromosome ideogram and sequence, may also be
added, permitting a comprehensive visualization of the genomic context
targeted by spacers in \linkS4class{GuideSet} objects.
}
\examples{
if (interactive()){
library(BSgenome.Hsapiens.UCSC.hg38)
data(cas9GuideSet, package="crisprViz")
data(cas12aGuideSet, package="crisprViz")
data(ltn1GeneModel, package="crisprViz")
plotMultipleGuideSets(list(SpCas9=cas9GuideSet, AsCas12a=cas12aGuideSet),
                      geneModel=ltn1GeneModel,
                      targetGene="LTN1",
                      bsgenome=BSgenome.Hsapiens.UCSC.hg38,
                      margin=0.2,
                      gcWindow=10)
}

}
\seealso{
\code{\link{plotGuideSet}}
}
\author{
Luke Hoberecht, Jean-Philippe Fortin
}
