% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbxml_handle.R
\name{dbxml2df}
\alias{dbxml2df}
\title{Convert drugbank database (xml file) into dataframe.}
\usage{
dbxml2df(xmlfile, version)
}
\arguments{
\item{xmlfile}{Character(1), file path to the xml file downloaded from the
DrugBank website at \url{https://www.drugbank.ca/releases/latest}}

\item{version}{Character(1), DrugBank version of the xml file}
}
\value{
Dataframe of drugbank xml database.
}
\description{
Download the original DrugBank database 
at \url{http://www.drugbank.ca/releases/latest} (xml file) into your current 
working directory and rename as "drugbank.xml"
then run: 
\code{drugbank_df = dbxml2df(xmlfile="drugbank.xml", version="5.0.10")}.
}
\note{
This process with take about 20 minutes.
}
\examples{
library(XML)
\dontrun{
## download the original drugbank database at 
\url{http://www.drugbank.ca/releases/latest} (xml file)
## into your current directory and rename as drugbank.xml

## convert drugbank database (xml file) into dataframe: 
drugbank_df <- dbxml2df(xmlfile="drugbank.xml", version="5.0.10")
}
}
\references{
\url{http://www.drugbank.ca/releases/latest}
}
\seealso{
\code{\link{df2SQLite}}
}
\author{
Yuzhu Duan \url{yduan004@ucr.edu}
}
