% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Margin_Cells.R
\name{cellMargin}
\alias{cellMargin}
\title{Removes or assign indicators to margin events.}
\usage{
cellMargin(
  flowframe,
  Channel = "SSC.W",
  type = c("manual", "estimate"),
  cut = NULL,
  y_toplot = "FSC,HLin"
)
}
\arguments{
\item{flowframe}{Flowframe containing margin events to be filtered out}

\item{Channel}{The channel on which margin events are. Defaults to 
SSC.W (side scatter width)}

\item{type}{The method to be used in gating out the margin cells. 
Can either be 'manual' where
user supplies a cut off point on the channel, 
1 = not margin 0 = margin}

\item{cut}{sould not be NULL if type = 'manual'}

\item{y_toplot}{channel on y-axis of plot with \emph{Channel} used to gate 
out margin events}
}
\value{
an object of class MarginEvents class containing slots; \itemize{
\item \strong{reducedflowframe -} flowframe without margin events
\item \strong{fullflowframe -} flowframe with an Margin.Indicator added as 
             an extra column added to the expression matrix
             to indicate which particles are margin events. 
             1 = not margin event,  0 = margin event
\item \strong{N_margin -} number of margin events recorded
\item \strong{N_cell -} numner of non-margin events
\item \strong{N_particle -} is the number of particles in total, 
             i.e. N_cell + N_margin
}
}
\description{
The function identifies margin events, 
             i.e. cells that are too large for the flow 
             cytometer to measure.
}
\details{
Users can either supply a cut-off point along the channel 
         describing particle width
         or allow the function to estimate the cut-off point using the
         \code{\link[flowDensity]{deGate}} function from the 
         \emph{flowDensity} package.
         A plot of channel against "FSC.HLin" is provided with a vertical 
         line showing the cut-off point separating margin events 
         from other cells.
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                 package = "cyanoFilter",
                 mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1)
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- lnTrans(x = flowfile_noneg, c('SSC.W', 'TIME'))
cellMargin(flowframe = flowfile_logtrans, Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")

}
