% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debris_nc.R
\name{debrisNc}
\alias{debrisNc}
\title{gates out or assign indicators to debris particle based on their chlorophyll 
expression.}
\usage{
debrisNc(flowframe, ch_chlorophyll, ch_p2, ph = 0.09, n_sd = 2)
}
\arguments{
\item{flowframe}{flowframe with debris and other cells.}

\item{ch_chlorophyll}{first flowcytometer channel that can be used to 
separate debris from the rest, e.g. "RED.B.HLin".}

\item{ch_p2}{second flowcytometer channel use for plotting
from the rest, e.g. "YEL.B.HLin"}

\item{ph}{the minimum peak height that should be considered. 
This aids the removal of tiny peaks. Defaults to 0.1}

\item{n_sd}{number of standard deviations away from peak should be 
considered to filter out debris}
}
\value{
list containing; \itemize{
\item \strong{syn - flowframe containing non-debris particles}
\item \strong{deb_pos - position of particles that are debris}
\item \strong{syn_pos - position of particles that are not debris}
}
}
\description{
The function takes in a flowframe and identifies debris 
             contained in the provided flowframe.
}
\details{
The function uses the \code{\link[flowDensity]{getPeaks}} and
         \code{\link[flowDensity]{deGate}} functions in the flowDensity 
         package to
         identify peaks in ch_chlorophyll, and identify cut-off points 
         #between these peaks.
         A plot of both channels supplied with horizontal line separating
         debris from other cell populations is also returned.
}
\examples{
flowfile_path <- system.file("extdata", "B4_18_1.fcs", 
                  package = "cyanoFilter",
              mustWork = TRUE)
flowfile <- flowCore::read.FCS(flowfile_path, alter.names = TRUE,
                               transformation = FALSE, emptyValue = FALSE,
                               dataset = 1) 
flowfile_nona <- cyanoFilter::noNA(x = flowfile)
flowfile_noneg <- cyanoFilter::noNeg(x = flowfile_nona)
flowfile_logtrans <- cyanoFilter::lnTrans(x = flowfile_noneg, 
c('SSC.W', 'TIME'))
cells_nonmargin <- cellMargin(flowframe = flowfile_logtrans, 
Channel = 'SSC.W',
           type = 'estimate', y_toplot = "FSC.HLin")
debrisNc(flowframe = reducedFlowframe(cells_nonmargin), 
          ch_chlorophyll = "RED.B.HLin",
          ch_p2 = "YEL.B.HLin",
          ph = 0.05)

}
