\name{quickPower}
\alias{quickPower}
\title{Obtain pre-calculated results from three available datasets}
\usage{
quickPower(data = "IAD")
}
\arguments{
  \item{data}{A character string specifying the dataset to be retrieved.
  Options are 'IAD', 'IBD', and 'ASD'.}
}
\value{
  \item{\code{ct_TDR_bio_smry}}{Cell-type-specific target TDR.}
  \item{\code{TDR_bio_smry}}{Average target TDR.}
  \item{\code{ct_PWR_bio_smry}}{Cell-type-specific target power.}
  \item{\code{PWR_bio_smry}}{Average target power.}
  \item{\code{PWR_strata_ct_bio_smry}}{Cell type specific target power by gene expression stratification.}
  \item{\code{PWR_strata_bio_smry}}{Average target power by gene expression stratification.}
  \item{\code{ct_FDC_bio_smry}}{Cell type specific target FDC.}
  \item{\code{FDC_bio_smry}}{Average target FDC.}
}
\description{
This function quickly outputs pre-calculated power evaluation results from three
datasets: (IAD, IBD, and ASD). The obtained results can be used to create
plots from plot functions.}

\details{
  \itemize{
    \item \code{IAD:} Whole transcriptome signatures of 6 immune cell subsets. The patients were drawn from subjects with a range of immune-related diseases.
    \item \code{IBD:} Inflammatory Bowel Disease
    \item \code{ASD:} Autism Spectrum Disorder.
  }
}


\examples{
# library(cypress)
Quick_power <- quickPower(data = "IAD")
}
\author{
Shilin Yu <sy597@georgetown.edu>
Guanqun Meng <gxm324@case.edu>
}
