% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{CytoKDEfeatures}
\alias{CytoKDEfeatures}
\alias{CytoKDEfeatures,CytoK-method}
\title{Generic function that returns the CytoK Differentially
Expressed (DE) features
Given a CytoK object, this function returns the
CytoK DE features}
\usage{
CytoKDEfeatures(object)

\S4method{CytoKDEfeatures}{CytoK}(object)
}
\arguments{
\item{object}{an object of class \code{CytoK}.}
}
\value{
The percent of differentially
expressed features based on alpha (level of significance).
}
\description{
Accessors for the 'CytoKDEfeatures'
slot of a CytoK object.
}
\examples{
data <- cbind(matrix(rnorm(1200,mean=2, sd=1.5),
nrow=200, ncol=6), matrix(rnorm(1200,mean=5, sd=1.9),
nrow=200, ncol=6))
data_CytoK <- CytoK(object=data,
group_factor = rep(c(0,1), each=6), lowerRho=2,
upperRho=12,gridRho=4,alpha = 0.05,
featureVars = NULL)
CytoKDEfeatures(data_CytoK)

}
