% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllslotAccessors.R
\docType{methods}
\name{CytoKFeatureVars}
\alias{CytoKFeatureVars}
\alias{CytoKFeatureVars,CytoK-method}
\title{Generic function that returns the CytoK Feature Vars}
\usage{
CytoKFeatureVars(object)

\S4method{CytoKFeatureVars}{CytoK}(object)
}
\arguments{
\item{object}{an object of class \code{CytoK}.}
}
\value{
Value of \code{featureVars} passed to \code{CytoK}. NULL
if \code{featureVars} was left blank
}
\description{
Given a CytoK object, this function returns the
CytoK Feature Vars

Accessors for the 'CytoKFeatureVars'
slot of a CytoK object.
}
\examples{
data <- cbind(matrix(rnorm(1200,mean=2, sd=1.5),
nrow=200, ncol=6), matrix(rnorm(1200,mean=5, sd=1.9),
nrow=200, ncol=6))
data_CytoK <- CytoK(object=data,
group_factor = rep(c(0,1), each=6), lowerRho=2,
upperRho=12,gridRho=4,alpha = 0.05,
featureVars = NULL)
CytoKFeatureVars(data_CytoK)

}
