% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plotCytoK}
\alias{plotCytoK}
\title{Heatmap of the differentially expressed data 
with features on 
the rows and samples (group factors) as the columns 
from \code{CytoK} and \code{CytoKDEData} function.}
\usage{
plotCytoK(object, group_factor, topK, featureVars = NULL)
}
\arguments{
\item{object}{a CytoK object from \code{CytoK}}

\item{group_factor}{a group level binary categorical 
response associated with each sample or column in the 
\code{object}. The order of the \code{group_factor} must 
match the order of the columns in \code{object}.}

\item{topK}{top K differentially expressed features.}

\item{featureVars}{(Optional) Vector of the columns which identify
features. If a `SummarizedExperiment` is used for `data`,
row variables will be used.}
}
\value{
A heatmap will be created showing the
samples on the columns and features on the rows.
}
\description{
This function plots a heatmap of the expression
matrix with features (e.g., cluster-marker combinations) on 
the rows and samples (group factors) as the columns.
}
\examples{
data <- cbind(matrix(rnorm(1200,mean=2, sd=1.5),
nrow=200, ncol=6), matrix(rnorm(1200,mean=5, sd=1.9),
nrow=200, ncol=6))
data_CytoK <- CytoK(object=data,
group_factor = rep(c(0,1), each=6), lowerRho=2,
upperRho=12,gridRho=4,alpha = 0.05,
featureVars = NULL)
data("cytoHDBMW")
data_CytoK_HD <- CytoK(object=cytoHDBMW,
group_factor = rep(c(0, 1), c(4, 4)), lowerRho=2,
upperRho=12,gridRho=4,alpha = 0.05,
featureVars = NULL)
plotCytoK(data_CytoK_HD,
group_factor = rep(c(0, 1), c(4, 4)),topK=10,
featureVars = NULL)
}
