% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dandelionR.R
\docType{package}
\name{dandelionR}
\alias{dandelionR-package}
\alias{dandelionR}
\title{dandelionR: Single-cell immune repertoire trajectory analysis}
\description{
dandelionR is an R package for performing single-cell immune repertoire
trajectory analysis, based on the original python implementation.
It provides the necessary functions to interface with scRepertoire and a
custom implementation of an absorbing Markov chain for pseudotime
inference, inspired by the Palantir Python package.
}
\section{Main functions}{

\itemize{
\item \code{\link{setupVdjPseudobulk}}: Preprocess V(D)J Data for Pseudobulk
Analysis.
\item \code{\link{vdjPseudobulk}}: Generate Pseudobulk V(D)J Feature Space.
\item \code{\link{markovProbability}}: Markov Chain Construction and
Probability Calculation.
\item \code{\link{projectPseudotimeToCell}}: Project Pseudotime and Branch
Probabilities to Single Cells.
}
}

\section{Vignettes}{

See the package vignettes for detailed workflows:
\code{vignette('dandelionR')}
}

\section{Installation}{

To install from Bioconductor, use:
\preformatted{
if (!requireNamespace('BiocManager', quietly = TRUE))
    install.packages('BiocManager')
BiocManager::install('dandelionR')
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://www.github.com/tuonglab/dandelionR/}
  \item Report bugs at \url{https://www.github.com/tuonglab/dandelionR/issues}
}

}
\author{
\strong{Maintainer}: Kelvin Tuong \email{z.tuong@uq.edu.au} (\href{https://orcid.org/0000-0002-6735-6808}{ORCID})

Authors:
\itemize{
  \item Jiawei Yu \email{jiawei.yu@uq.edu.au} (\href{https://orcid.org/0009-0005-9170-7881}{ORCID})
  \item Nicholas Borcherding \email{borcherding@wustl.edu} (\href{https://orcid.org/0000-0003-1427-6342}{ORCID})
}

}
\keyword{internal}
