% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaCaptureC.R
\name{getSignificantRegions}
\alias{getSignificantRegions}
\title{Get ths significant regions from delta data}
\usage{
getSignificantRegions(
  deltaSE,
  regionOfInterest,
  viewpointRegion,
  smallBinSize,
  bigBinSize,
  numPermutations = 1000,
  pValue = 0.05
)
}
\arguments{
\item{deltaSE}{a ranged summarized experiment with a one-column
assay giving the delta mean count}

\item{regionOfInterest}{a GenomicRanges object specifying the
region  of interest}

\item{viewpointRegion}{the region withheld from arbitrary
permutation}

\item{smallBinSize}{size to bin original data to for permutation}

\item{bigBinSize}{size to bin data to for significance testing.  Must be a multiple of smallBinSize}

\item{numPermutations}{= 1000 the number of permutations to be used for
permutation testing}

\item{pValue}{the desired significance level}
}
\value{
a GRanges object giving the bigBin binning of region of
interest whose mcols gives the values of delta and logicals
telling whether the bin is in the viewpoint regsion and whether
it rises to statistical significance
}
\description{
This function takes delta data as a SummarizedExperiment and
required ancillary data and returns a GenomicRanges object whose
mcols indicate the significant regions.
}
