% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{plotDmmHistogram}
\alias{plotDmmHistogram}
\alias{plotDmmHistogram,Demuxmix,missing-method}
\alias{plotDmmHistogram,Demuxmix,ANY-method}
\title{Plotting a histogram with mixture probability mass function}
\usage{
plotDmmHistogram(object, hto, quantile = 0.95, binwidth = 5)
}
\arguments{
\item{object}{An object of class \code{\link{Demuxmix}}.}

\item{hto}{Optional vector specifying a subset of HTOs in \code{object} which
should be used by this function.}

\item{quantile}{Quantile of the mixture distribution which is used as
right limit of the plot's x axis.}

\item{binwidth}{Width of the bins of the histogram.}
}
\value{
An object of class \code{ggplot} is returned, if only one HTO is
  plotted. If several HTOs are plotted simultaneously, a grid of plots is
  returned.
}
\description{
This methods plots the mixture probability mass function with the negative
and positive component on top of a histogram of the HTO counts used to fit
the mixture model. The mixture model must be generated by
\code{\link{demuxmix}}.
}
\details{
A histogram overlaid with the pmf is a standard tool to 
  assess the fit of a the mixture model and trivial for a naive mixture
  model. However, if a regression mixture model is given, the expectation
  values of the components are different for each droplet depending on the
  covariates (here the number of genes detected in the droplet). This method
  calculates the weighted mean number of detected genes in droplets in the
  positive and negative component, and then uses these numbers to
  calculate expectation values for an average droplet of the positive
  and negative component. The HTO counts shown in the histogram
  are adjusted to account for different numbers of detected genes by
  replacing the original HTO counts with the expected counts given the mean
  number of detected genes plus the residuals from the regression model. In
  other words, the effect of the number of detected genes was regressed out
  before plotting the HTO counts in the histogram.
  
  It may be useful to zoom into the plot to obtain a better view
  of the fit. To restrict the plot to a certain range on the x or y axis,
  the method \code{\link[ggplot2]{coord_cartesian}} from the \code{ggplot2}
  package should be used (see examples).
}
\examples{
set.seed(2642)
simdata <- dmmSimulateHto(class = rbind(c(rep(TRUE, 220), rep(FALSE, 200)),
                                        c(rep(FALSE, 200), rep(TRUE, 220))))

dmm <- demuxmix(simdata$hto, simdata$rna)
\donttest{plotDmmHistogram(dmm)}
p <- plotDmmHistogram(dmm, hto = 1)
\donttest{p + ggplot2::coord_cartesian(xlim = c(25, 100), ylim = c(0, 0.01))}

}
\seealso{
\code{\link{demuxmix}}
}
