% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffuse_raw.R
\name{diffuse_raw}
\alias{diffuse_raw}
\title{Diffuse scores on a network}
\usage{
diffuse_raw(graph, scores, z = FALSE, K = NULL, ...)
}
\arguments{
\item{graph}{\pkg{igraph} object for the diffusion}

\item{scores}{list of score matrices. For a single input with a
single background, supply a list with a vector column}

\item{z}{logical, should z-scores be computed instead of raw scores?}

\item{K}{optional matrix, precomputed diffusion kernel}

\item{...}{currently ignored arguments}
}
\value{
A list of scores, with the same length and
dimensions as \code{scores}
}
\description{
Function \code{diffuse} takes a network in
\pkg{igraph} format and an initial state
to score all the nodes in the network.
}
\examples{
# Using a list as input (needed)
data(graph_toy)
list_input <- list(myInput1 = graph_toy$input_mat)
diff_raw <- diffuse_raw(
    graph = graph_toy,
    scores = list_input)
diff_z <- diffuse_raw(
    graph = graph_toy,
    scores = list_input,
    z = TRUE)
}
