% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discordant.R
\name{discordantRun}
\alias{discordantRun}
\title{Run Discordant Algorithm}
\usage{
discordantRun(
  v1,
  v2,
  x,
  y = NULL,
  transform = TRUE,
  subsampling = FALSE,
  subSize = NULL,
  iter = 100,
  components = 3
)
}
\arguments{
\item{v1}{Vector of correlation coefficients in group 1}

\item{v2}{Vector of correlation coefficients in group 2}

\item{x}{ExpressionSet of -omics data}

\item{y}{ExpressionSet of -omics data, induces dual -omics analysis}

\item{transform}{If TRUE v1 and v2 will be Fisher transformed}

\item{subsampling}{If TRUE subsampling will be run}

\item{subSize}{Indicates how many feature pairs to be used for subsampling. 
Default is the feature size in x}

\item{iter}{Number of iterations for subsampling. Default is 100}

\item{components}{Number of components in mixture model.}
}
\value{
\describe{
  \item{discordPPVector}{Vector of differentially correlated posterior 
  probabilities.}
  \item{discordPPMatrix}{Matrix of differentially correlated posterior 
  probabilities where rows and columns reflect features}
  \item{classVector}{Vector of classes that have the highest posterior 
  probability}
  \item{classMatrix}{Matrix of classes that have hte highest posterior 
  probability where rows and columns reflect features}
  \item{probMatrix}{Matrix of posterior probabilities where rows are each 
  molecular feature pair and columns are nine different classes}
  \item{loglik}{Final log likelihood}
}
}
\description{
Runs discordant algorithm on two vectors of correlation coefficients.
}
\details{
The discordant algorithm is based on a Gaussian mixture model. If there are 
three components, correlation coefficients are clustered into negative 
correlations (-), positive correlations (+) and no correlation (0). If there 
are five components, then there are two more classes for very negative 
correlation (--) and very positive correlations (++). All possible 
combinations for these components are made into classes. If there are three 
components, there are 9 classes. If there are five components, there are 25 
classes.

The posterior probabilities for each class are generated and outputted into 
the value probMatrix. The value probMatrix is a matrix where each column is a
 class and each row is a feature pair. The values discordPPVector and 
 discordPPMatrix are the summed differential correlation posterior 
 probability for each feature pair. The values classVector and classMatrix 
 are the class with the highest posterior probability for each feature pair.
}
\examples{
# Load Data
data(TCGA_GBM_miRNA_microarray)
data(TCGA_GBM_transcript_microarray)
print(colnames(TCGA_GBM_transcript_microarray)) # look at groups
groups <- c(rep(1,10), rep(2,20))

## DC analysis on only transcripts pairs

vectors <- createVectors(TCGA_GBM_transcript_microarray, 
                         groups = groups)
result <- discordantRun(vectors$v1, vectors$v2, 
                        TCGA_GBM_transcript_microarray)

## DC analysis on miRNA-transcript pairs

vectors <- createVectors(TCGA_GBM_transcript_microarray, 
                         TCGA_GBM_miRNA_microarray, groups = groups, 
                         cor.method = c("pearson"))
result <- discordantRun(vectors$v1, vectors$v2, 
                        TCGA_GBM_transcript_microarray, 
                       TCGA_GBM_miRNA_microarray)
}
\references{
Siska C, Bowler R and Kechris K. The Discordant Method: A Novel Approach for 
Differential Correlation (2015), Bioinformatics. 32 (5): 690-696.

Lai Y, Zhang F, Nayak TK, Modarres R, Lee NH and McCaffrey TA. Concordant 
integrative gene set enrichment analysis of multiple large-scale two-sample 
expression data sets. (2014) BMC Genomics 15, S6.

Lai Y, Adam B-l, Podolsky R, She J-X. A mixture model approach to the tests 
of concordance and discordancd between two large-scale experiments with two 
sample groups. (2007) Bioinformatics 23, 1243-1250.
}
\author{
Charlotte Siska \email{siska.charlotte@gmail.com}

Max McGrath \email{max.mcgrath@ucdenver.edu}
}
