% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDimReduction.R
\name{addDimReduction}
\alias{addDimReduction}
\title{Add any dimensionality reduction space to a SingleCellExperiment object containing bulk or single-cell data}
\usage{
addDimReduction(object, embeddings, name, key = .gen_key(name))
}
\arguments{
\item{object}{the bulk or single-cell \code{\linkS4class{SingleCellExperiment}} object to add the dimensionality reduction to.
(dittoSeq utilizes the SingleCellExperiment object even for bulk data because it provides a convenient slots for all data that dittoSeq requires)}

\item{embeddings}{a numeric matrix or matrix-like object, with number of rows equal to ncol(object), containing the coordinates of all cells / samples within the dimensionality reduction space.}

\item{name}{String name for the reduction slot. Example: "pca".
This will become the name of the slot, and what should be provided to the \code{reduction.use} input when making a \code{\link{dittoDimPlot}}.
When the name given is the same as that of a slot that already exists inside the \code{object}, the previous slot is replaced with the newly provided data.}

\item{key}{String, like "PC", which sets the default axes-label prefix when this reduction is used for making a \code{\link{dittoDimPlot}}.
If nothing is provided, a key will be automatically generated.}
}
\value{
Outputs a \code{\linkS4class{SingleCellExperiment}} object with an added or replaced dimensionality reduction slot.
}
\description{
Add any dimensionality reduction space to a SingleCellExperiment object containing bulk or single-cell data
}
\examples{

example("importDittoBulk", echo = FALSE)

# Calculate PCA
#   NOTE: This is typically not done with all genes in the dataset.
#   The inclusion of this example code is not an endorsement of a particular
#   method of PCA. Consult yourself, a bioinformatician, or literature for
#   tips on proper techniques.
embeds <- prcomp(t(logcounts(myRNA)), center = TRUE, scale = TRUE)$x

myRNA <- addDimReduction(
    object = myRNA,
    embeddings = embeds,
    name = "pca",
    key = "PC")

# Visualize conditions metadata on a PCA plot
dittoDimPlot(myRNA, "conditions", reduction.use = "pca", size = 3)

}
\seealso{
\code{\link{addPrcomp}} for a prcomp specific PCA import wrapper

\code{\link{importDittoBulk}} for initial import of bulk RNAseq data into dittoSeq as a \code{\linkS4class{SingleCellExperiment}}.

\code{\link{dittoDimPlot}} for visualizing how samples group within added dimensionality reduction spaces
}
\author{
Daniel Bunis
}
