% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene-getters.R
\name{getGenes}
\alias{getGenes}
\title{Returns the names of all genes of a target object.}
\usage{
getGenes(object, assay = .default_assay(object), swap.rownames = NULL)
}
\arguments{
\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{assay}{Single string or integer that sets which set of seq data inside the object to check.}

\item{swap.rownames}{optionally named string or string vector.
For SummarizedExperiment or SingleCellExperiment objects, its value(s) specifies the column name of rowData(object) to be used to identify features instead of rownames(object).
When targeting multiple modalities (alternative experiments), names can be used to specify which level / alternative experiment (use 'main' for the top-level) individual values should be used for.
See \code{\link{GeneTargeting}} for more specifics and examples.}
}
\value{
A string vector, returns the names of all genes of the \code{object} for the requested \code{assay}.
}
\description{
Returns the names of all genes of a target object.
}
\examples{
example(importDittoBulk, echo = FALSE)
getGenes(object = myRNA, assay = "counts")

# To see all genes of an object for the default assay that dittoSeq would use
# leave out the assay input
getGenes(myRNA)

# Seurat
# pbmc <- Seurat::pbmc_small
# # To see all genes of an object of a particular assay
# getGenes(pbmc, assay = "RNA")

}
\seealso{
\code{\link{isGene}} for returning all genes in an \code{object}

\code{\link{gene}} for obtaining the expression data of genes
}
\author{
Daniel Bunis
}
