% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simpleFilter.R
\name{simpleFilter}
\alias{simpleFilter}
\title{simpleFilter Function to filter expression data of an object.}
\usage{
simpleFilter(se, mean_cutoff=NULL, min_cutoff=NULL, median_cutoff=
NULL, counts=TRUE)
}
\arguments{
\item{se}{A SummarizedExperiment object.}

\item{mean_cutoff}{The lower cutoff, using mean.}

\item{min_cutoff}{The cutoff, expressed as a minimum acceptable value.}

\item{median_cutoff}{The cutoff, using a median value.}

\item{counts}{Boolean, use raw counts data (default) or RPKM.}
}
\value{
Returns a filtered SummarizedExperiment object.
}
\description{
simpleFilter is a filtering function used to remove rows
(genes) of various expression data.
}
\details{
This function filters the expression of the supplied obj.
}
\examples{
data(hmel.se) ; f_se <- simpleFilter(se, mean_cutoff=0.5)
}
\references{
The "doseR" package, 2018 (in press).
}
\author{
AJ Vaestermark, JR Walters.
}
